/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.texture.TextureBorders;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;

public class TextureMenuBarUI
extends BasicMenuBarUI {
    public static ComponentUI createUI(JComponent x) {
        return new TextureMenuBarUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c != null && c instanceof JMenuBar) {
            ((JMenuBar)c).setBorder(TextureBorders.getMenuBarBorder());
            ((JMenuBar)c).setBorderPainted(true);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        TextureUtils.fillComponent(g, c, 7);
        if (AbstractLookAndFeel.getTheme().isDarkTexture()) {
            Graphics2D g2D = (Graphics2D)g;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.black);
            g2D.drawLine(0, 0, c.getWidth() - 1, 0);
            alpha = AlphaComposite.getInstance(3, 0.2f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawLine(0, c.getHeight() - 1, c.getWidth() - 1, c.getHeight() - 1);
            g2D.setComposite(savedComposite);
        }
    }
}

