/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseIcons;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JButton;

public class SmartIcons
extends BaseIcons {
    public static Icon getIconIcon() {
        if (iconIcon == null) {
            iconIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacIconIcon() : new TitleButtonIcon(0);
        }
        return iconIcon;
    }

    public static Icon getMinIcon() {
        if (minIcon == null) {
            minIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMinIcon() : new TitleButtonIcon(1);
        }
        return minIcon;
    }

    public static Icon getMaxIcon() {
        if (maxIcon == null) {
            maxIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacMaxIcon() : new TitleButtonIcon(2);
        }
        return maxIcon;
    }

    public static Icon getCloseIcon() {
        if (closeIcon == null) {
            closeIcon = AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn() ? new BaseIcons.MacCloseIcon() : new TitleButtonIcon(3);
        }
        return closeIcon;
    }

    private static class TitleButtonIcon
    implements Icon {
        private static final Color CLOSER_COLOR_LIGHT = new Color(241, 172, 154);
        private static final Color CLOSER_COLOR_DARK = new Color(224, 56, 2);
        public static final int ICON_ICON_TYP = 0;
        public static final int MIN_ICON_TYP = 1;
        public static final int MAX_ICON_TYP = 2;
        public static final int CLOSE_ICON_TYP = 3;
        private int iconTyp = 0;

        public TitleButtonIcon(int typ) {
            this.iconTyp = typ;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int w = c.getWidth();
            int h = c.getHeight();
            JButton b = (JButton)c;
            Graphics2D g2D = (Graphics2D)g;
            boolean isActive = JTattooUtilities.isActive(b);
            boolean isPressed = b.getModel().isPressed();
            boolean isArmed = b.getModel().isArmed();
            boolean isRollover = b.getModel().isRollover();
            Color cHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowTitleColorLight(), 40.0);
            Color cLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 10.0);
            if (this.iconTyp == 3) {
                cHi = CLOSER_COLOR_LIGHT;
                cLo = CLOSER_COLOR_DARK;
            }
            Color fcHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 80.0);
            Color fcLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowTitleColorDark(), 40.0);
            if (!isActive) {
                cHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight(), 40.0);
                cLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark(), 10.0);
                fcHi = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorLight(), 60.0);
                fcLo = ColorHelper.darker(AbstractLookAndFeel.getTheme().getWindowInactiveTitleColorDark(), 10.0);
            }
            if (isPressed && isArmed) {
                Color cTemp = ColorHelper.darker(cLo, 10.0);
                cLo = ColorHelper.darker(cHi, 10.0);
                cHi = cTemp;
            } else if (isRollover) {
                cHi = ColorHelper.brighter(cHi, 30.0);
                cLo = ColorHelper.brighter(cLo, 30.0);
            }
            Shape savedClip = g.getClip();
            Area area = new Area(new RoundRectangle2D.Double(1.0, 1.0, w - 1, h - 1, 3.0, 3.0));
            g2D.setClip(area);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, fcLo, w, h, fcHi));
            g.fillRect(1, 1, w - 1, h - 1);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, ColorHelper.brighter(cHi, 80.0), w, h, ColorHelper.darker(cLo, 30.0)));
            g.fillRect(2, 2, w - 3, h - 3);
            g2D.setPaint(new GradientPaint(0.0f, 0.0f, cHi, w, h, cLo));
            g.fillRect(3, 3, w - 5, h - 5);
            g2D.setClip(savedClip);
            cHi = Color.white;
            cLo = ColorHelper.darker(cLo, 30.0);
            Icon icon = null;
            switch (this.iconTyp) {
                case 0: {
                    icon = new BaseIcons.IconSymbol(cHi, cLo, null);
                    break;
                }
                case 1: {
                    icon = new BaseIcons.MinSymbol(cHi, cLo, null);
                    break;
                }
                case 2: {
                    icon = new BaseIcons.MaxSymbol(cHi, cLo, null);
                    break;
                }
                case 3: {
                    icon = new BaseIcons.CloseSymbol(cHi, cLo, null);
                    break;
                }
            }
            if (icon != null) {
                icon.paintIcon(c, g, 0, 0);
            }
        }
    }
}

