/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollButton;
import com.jtattoo.plaf.ColorHelper;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.Icon;
import javax.swing.UIManager;

public abstract class XPScrollButton
extends BaseScrollButton {
    public XPScrollButton(int direction, int width) {
        super(direction, width);
    }

    private Icon getUpArrowIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            return laf.getIconFactory().getUpArrowIcon();
        }
        return null;
    }

    private Icon getDownArrowIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            return laf.getIconFactory().getDownArrowIcon();
        }
        return null;
    }

    private Icon getLeftArrowIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            return laf.getIconFactory().getLeftArrowIcon();
        }
        return null;
    }

    private Icon getRightArrowIcon() {
        if (UIManager.getLookAndFeel() instanceof AbstractLookAndFeel) {
            AbstractLookAndFeel laf = (AbstractLookAndFeel)UIManager.getLookAndFeel();
            return laf.getIconFactory().getRightArrowIcon();
        }
        return null;
    }

    public Color getFrameColor() {
        return Color.white;
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x;
        Icon icon;
        Graphics2D g2D = (Graphics2D)g;
        Composite savedComposite = g2D.getComposite();
        Paint savedPaint = g2D.getPaint();
        boolean isPressed = this.getModel().isPressed();
        boolean isRollover = this.getModel().isRollover();
        int width = this.getWidth();
        int height = this.getHeight();
        Color[] tc = AbstractLookAndFeel.getTheme().getThumbColors();
        Color c1 = tc[0];
        Color c2 = tc[tc.length - 1];
        if (isPressed) {
            c1 = ColorHelper.darker(c1, 5.0);
            c2 = ColorHelper.darker(c2, 5.0);
        } else if (isRollover) {
            c1 = ColorHelper.brighter(c1, 20.0);
            c2 = ColorHelper.brighter(c2, 20.0);
        }
        g2D.setPaint(new GradientPaint(0.0f, 0.0f, c1, width, height, c2));
        g.fillRect(0, 0, width, height);
        g2D.setPaint(savedPaint);
        g.setColor(this.getFrameColor());
        g.drawLine(1, 1, width - 2, 1);
        g.drawLine(1, 1, 1, height - 3);
        g.drawLine(width - 2, 1, width - 2, height - 3);
        g.drawLine(2, height - 2, width - 3, height - 2);
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
        g2D.setComposite(alpha);
        g2D.setColor(c2);
        g.drawLine(2, 2, width - 3, 2);
        g.drawLine(2, 3, 2, height - 3);
        g.setColor(ColorHelper.darker(c2, 40.0));
        g.drawLine(width - 1, 2, width - 1, height - 3);
        g.drawLine(3, height - 1, width - 3, height - 1);
        alpha = AlphaComposite.getInstance(3, 0.2f);
        g2D.setComposite(alpha);
        g.drawLine(1, height - 2, 2, height - 1);
        g.drawLine(width - 1, height - 2, width - 2, height - 1);
        g2D.setComposite(savedComposite);
        switch (this.getDirection()) {
            case 1: {
                icon = this.getUpArrowIcon();
                x = width / 2 - icon.getIconWidth() / 2;
                y = height / 2 - icon.getIconHeight() / 2;
                break;
            }
            case 5: {
                icon = this.getDownArrowIcon();
                x = width / 2 - icon.getIconWidth() / 2;
                y = height / 2 - icon.getIconHeight() / 2 + 1;
                break;
            }
            case 7: {
                icon = this.getLeftArrowIcon();
                x = width / 2 - icon.getIconWidth() / 2;
                y = height / 2 - icon.getIconHeight() / 2;
                break;
            }
            default: {
                icon = this.getRightArrowIcon();
                x = width / 2 - icon.getIconWidth() / 2 + 1;
                y = height / 2 - icon.getIconHeight() / 2;
            }
        }
        icon.paintIcon(this, g, x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        switch (this.getDirection()) {
            case 1: {
                return new Dimension(this.buttonWidth, this.buttonWidth);
            }
            case 5: {
                return new Dimension(this.buttonWidth, this.buttonWidth);
            }
            case 3: {
                return new Dimension(this.buttonWidth, this.buttonWidth);
            }
            case 7: {
                return new Dimension(this.buttonWidth, this.buttonWidth);
            }
        }
        return new Dimension(0, 0);
    }
}

