/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class BasePopupMenuUI
extends BasicPopupMenuUI {
    protected static Robot robot = null;
    protected BufferedImage screenImage = null;
    protected MyPopupMenuListener myPopupListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new BasePopupMenuUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.popupMenu.setOpaque(false);
        this.popupMenu.setLightWeightPopupEnabled(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.setOpaque(true);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        if (!this.isMenuOpaque()) {
            this.myPopupListener = new MyPopupMenuListener(this);
            this.popupMenu.addPopupMenuListener(this.myPopupListener);
        }
    }

    @Override
    public void uninstallListeners() {
        if (!this.isMenuOpaque()) {
            this.popupMenu.removePopupMenuListener(this.myPopupListener);
        }
        super.uninstallListeners();
    }

    private boolean isMenuOpaque() {
        return AbstractLookAndFeel.getTheme().isMenuOpaque() || this.getRobot() == null;
    }

    private Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
        return robot;
    }

    @Override
    public Popup getPopup(JPopupMenu popupMenu, int x, int y) {
        Popup popup = super.getPopup(popupMenu, x, y);
        if (!this.isMenuOpaque()) {
            try {
                Dimension size = popupMenu.getPreferredSize();
                if (size.width > 0 && size.height > 0) {
                    Rectangle screenRect = new Rectangle(x, y, size.width, size.height);
                    this.screenImage = this.getRobot().createScreenCapture(screenRect);
                }
                for (int i = 0; i < popupMenu.getComponentCount(); ++i) {
                    if (!(popupMenu.getComponent(i) instanceof JPanel)) continue;
                    JPanel panel = (JPanel)popupMenu.getComponent(i);
                    panel.setOpaque(true);
                }
            }
            catch (Exception ex) {
                this.screenImage = null;
            }
        }
        return popup;
    }

    private void resetScreenImage() {
        this.screenImage = null;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (this.screenImage != null) {
            g.drawImage(this.screenImage, 0, 0, null);
        } else {
            g.setColor(AbstractLookAndFeel.getMenuBackgroundColor());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    public static class MyPopupMenuListener
    implements PopupMenuListener {
        private BasePopupMenuUI popupMenuUI = null;

        public MyPopupMenuListener(BasePopupMenuUI aPopupMenuUI) {
            this.popupMenuUI = aPopupMenuUI;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.popupMenuUI.screenImage != null) {
                JPopupMenu popup = (JPopupMenu)e.getSource();
                JRootPane root = popup.getRootPane();
                if (popup.isShowing() && root.isShowing()) {
                    Point ptPopup = popup.getLocationOnScreen();
                    Point ptRoot = root.getLocationOnScreen();
                    Graphics g = popup.getRootPane().getGraphics();
                    g.drawImage(this.popupMenuUI.screenImage, ptPopup.x - ptRoot.x, ptPopup.y - ptRoot.y, null);
                    this.popupMenuUI.resetScreenImage();
                }
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }
    }
}

