/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;

public class BaseFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent c) {
        return new BaseFormattedTextFieldUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (BaseFormattedTextFieldUI.this.getComponent() != null) {
                        BaseFormattedTextFieldUI.this.orgBorder = BaseFormattedTextFieldUI.this.getComponent().getBorder();
                        LookAndFeel laf = UIManager.getLookAndFeel();
                        if (laf instanceof AbstractLookAndFeel && BaseFormattedTextFieldUI.this.orgBorder instanceof UIResource) {
                            Border focusBorder = ((AbstractLookAndFeel)laf).getBorderFactory().getFocusFrameBorder();
                            BaseFormattedTextFieldUI.this.getComponent().setBorder(focusBorder);
                        }
                        BaseFormattedTextFieldUI.this.getComponent().invalidate();
                        BaseFormattedTextFieldUI.this.getComponent().repaint();
                    }
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (BaseFormattedTextFieldUI.this.getComponent() != null && BaseFormattedTextFieldUI.this.orgBorder instanceof UIResource) {
                        BaseFormattedTextFieldUI.this.getComponent().setBorder(BaseFormattedTextFieldUI.this.orgBorder);
                        BaseFormattedTextFieldUI.this.getComponent().invalidate();
                        BaseFormattedTextFieldUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void paintBackground(Graphics g) {
        g.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            g.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        g.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    @Override
    protected void paintSafely(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(g);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }
}

