/*
 * Decompiled with CFR 0.152.
 */
package SceneList;

import Main.NotificationMessage;
import Scene.Scene;
import SceneList.SceneNameGetter;
import SceneList.SceneParameter;
import SceneList.ThumbnailListEntry;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Observable;
import java.util.Properties;
import javax.swing.JFileChooser;

public class SceneList
extends Observable {
    public static final int MAX_NUM_SCENES = 300;
    public static final String FILE_TYPE = "Scene_List_File";
    SceneParameter[] scene_parameters = new SceneParameter[300];
    int index;
    int selected_index;
    int number_of_entries;
    SceneNameGetter scene_name_getter;

    public SceneList() {
        int i = 0;
        while (i < 300) {
            this.scene_parameters[i] = new SceneParameter();
            ++i;
        }
        this.scene_name_getter = new SceneNameGetter(this);
        this.number_of_entries = 0;
    }

    public void addScene(Scene scene, int index) {
        this.selected_index = index;
        if (index < 299) {
            if (this.number_of_entries > 0) {
                int i = this.number_of_entries;
                while (i > index) {
                    this.copySceneParameters(this.scene_parameters[i - 1], this.scene_parameters[i]);
                    --i;
                }
            }
            ++this.number_of_entries;
            this.index = index;
            scene.generatePreviewImage();
            this.extractSceneParameters(scene, this.scene_parameters[index + 1]);
            this.scene_name_getter.setSceneName("New Scene");
            this.scene_name_getter.setVisible(true);
            this.selected_index = index + 1;
        } else {
            System.out.println("SceneList: MAX_NUM_SCENES reached.");
        }
    }

    public void replaceScene(Scene scene, int index) {
        this.selected_index = index;
        if (index >= 0 && index < 299) {
            scene.generatePreviewImage();
            String old_scene_name = this.scene_parameters[index].scene_name;
            this.extractSceneParameters(scene, this.scene_parameters[index]);
            this.index = index - 1;
            this.scene_name_getter.setSceneName(old_scene_name);
            this.scene_name_getter.setVisible(true);
        } else {
            System.out.println("SceneList: MAX_NUM_SCENES reached.");
        }
    }

    public void moveUp(int index) {
        this.selected_index = index;
        SceneParameter old = new SceneParameter();
        if (index > 0 && index < this.number_of_entries) {
            this.copySceneParameters(this.scene_parameters[index], old);
            this.copySceneParameters(this.scene_parameters[index - 1], this.scene_parameters[index]);
            this.copySceneParameters(old, this.scene_parameters[index - 1]);
            this.selected_index = index - 1;
            this.setChanged();
            this.notifyObservers((Object)NotificationMessage.SCENE_LIST_CHANGED_NOTIFICATION);
        } else {
            System.out.println("SceneList: Wrong index.");
        }
    }

    public void moveDown(int index) {
        this.selected_index = index;
        SceneParameter old = new SceneParameter();
        if (index >= 0 && index < this.number_of_entries - 1) {
            this.copySceneParameters(this.scene_parameters[index], old);
            this.copySceneParameters(this.scene_parameters[index + 1], this.scene_parameters[index]);
            this.copySceneParameters(old, this.scene_parameters[index + 1]);
            this.selected_index = index + 1;
            this.setChanged();
            this.notifyObservers((Object)NotificationMessage.SCENE_LIST_CHANGED_NOTIFICATION);
        } else {
            System.out.println("SceneList: Wrong index.");
        }
    }

    public void removeListeEntry(int index) {
        this.selected_index = index;
        if (index >= 0 && index < this.number_of_entries && this.number_of_entries > 0) {
            int i = index;
            while (i < this.number_of_entries) {
                this.copySceneParameters(this.scene_parameters[i + 1], this.scene_parameters[i]);
                ++i;
            }
            --this.number_of_entries;
            this.selected_index = this.number_of_entries == 0 ? index - 1 : (index == 0 ? 0 : index - 1);
            this.setChanged();
            this.notifyObservers((Object)NotificationMessage.SCENE_LIST_CHANGED_NOTIFICATION);
        } else {
            System.out.println("SceneList: Wrong index or list already empty");
        }
    }

    public void clearList() {
        this.number_of_entries = 0;
        this.selected_index = -1;
        this.setChanged();
        this.notifyObservers((Object)NotificationMessage.SCENE_LIST_CHANGED_NOTIFICATION);
    }

    public void setSceneName(String scene_name) {
        this.scene_parameters[this.index + 1].scene_name = scene_name;
        this.setChanged();
        this.notifyObservers((Object)NotificationMessage.SCENE_LIST_CHANGED_NOTIFICATION);
    }

    public SceneParameter getSceneParameter(int index) {
        if (index >= 0 && index < 300) {
            return this.scene_parameters[index];
        }
        System.out.println("SceneList: Wrong scene index.");
        return new SceneParameter();
    }

    public ThumbnailListEntry[] getSceneListEntries() {
        ThumbnailListEntry[] result = new ThumbnailListEntry[this.number_of_entries];
        int i = 0;
        while (i < this.number_of_entries) {
            result[i] = new ThumbnailListEntry(this.scene_parameters[i].scene_name, this.scene_parameters[i].preview_image, this.scene_parameters[i].size);
            ++i;
        }
        return result;
    }

    public String[] getSceneListEntrieNames() {
        String[] result = new String[this.number_of_entries];
        int i = 0;
        while (i < this.number_of_entries) {
            result[i] = this.scene_parameters[i].scene_name;
            ++i;
        }
        return result;
    }

    public int getNumberOfEntries() {
        return this.number_of_entries;
    }

    public int getSelectedIndex() {
        return this.selected_index;
    }

    public void saveSceneList(Component cmpt) {
        JFileChooser fc = new JFileChooser();
        int return_val = fc.showSaveDialog(cmpt);
        if (return_val == 0) {
            try {
                File file = fc.getSelectedFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                Properties scene_list_properties = new Properties();
                this.addSceneListProperties(scene_list_properties);
                scene_list_properties.store(new FileOutputStream(file), "Glediator Scene List File");
            }
            catch (Exception ex) {
                System.out.println("SceneList: Error during saving scene list.");
            }
        }
    }

    public void loadSceneList(Component cmpt) {
        JFileChooser fc = new JFileChooser();
        int return_val = fc.showOpenDialog(cmpt);
        if (return_val == 0) {
            try {
                File file = fc.getSelectedFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                Properties scene_list_properties = new Properties();
                scene_list_properties.load(new FileInputStream(file));
                this.extractSceneListProperties(scene_list_properties);
            }
            catch (Exception ex) {
                System.out.println("SceneList: Error during reading scene list.");
            }
        }
    }

    public void addSceneListProperties(Properties scene_list_properties) {
        String prop = "SL_File_Type";
        String val = FILE_TYPE;
        scene_list_properties.setProperty(prop, val);
        prop = "SL_Number_Of_Entries";
        val = "" + this.number_of_entries;
        scene_list_properties.setProperty(prop, val);
        prop = "SL_Number_Of_Generators";
        val = "5";
        scene_list_properties.setProperty(prop, val);
        int i = 0;
        while (i < this.number_of_entries) {
            this.scene_parameters[i].addSceneParameter("SL", scene_list_properties, i);
            ++i;
        }
    }

    public void extractSceneListProperties(Properties scene_list_properties) {
        String prop = "SL_File_Type";
        String val = scene_list_properties.getProperty(prop);
        if (val.equals(FILE_TYPE)) {
            prop = "SL_Number_Of_Entries";
            val = scene_list_properties.getProperty(prop);
            this.number_of_entries = Integer.parseInt(val);
            int i = 0;
            while (i < this.number_of_entries) {
                this.scene_parameters[i].extractSceneParameter("SL", i, scene_list_properties);
                ++i;
            }
            this.setChanged();
            this.notifyObservers((Object)NotificationMessage.SCENE_LIST_CHANGED_NOTIFICATION);
        } else {
            System.out.println("SceneList: Wrong file type.");
        }
    }

    public void extractSceneParameters(Scene scene, SceneParameter scene_parameter) {
        scene_parameter.size[0] = scene.getMatrixSize()[0];
        scene_parameter.size[1] = scene.getMatrixSize()[1];
        int i = 0;
        while (i < 5) {
            scene_parameter.genertator_types[i] = scene.generators[i].getGeneratorType();
            scene_parameter.generator_parameters[i] = scene.generators[i].getParameterString();
            scene_parameter.level_values[i] = scene.getLevel(i);
            scene_parameter.speed_values[i] = scene.getGeneratorSpeed(i);
            scene_parameter.filter_modi[i] = scene.filters[i].getFilterMode();
            scene_parameter.mixer_modi[i] = scene.getMixerMode(i);
            ++i;
        }
        scene_parameter.effect_mode = scene.effect.getEffectMode();
        scene_parameter.effect_direction = scene.effect.getEffectDirection();
        scene_parameter.effect_methode = scene.effect.getEffectMethode();
        scene_parameter.effect_value = scene.effect.getValue();
        scene_parameter.effect_lower_limit = scene.effect.getLowerLimit();
        scene_parameter.effect_upper_limit = scene.effect.getUpperLimit();
        scene_parameter.effect_timer_value = scene.effect.getTimerValue();
        scene_parameter.effect_is_active = scene.effect.getActiveState();
        int size = scene_parameter.size[0] * scene_parameter.size[1];
        scene_parameter.preview_image = new Color[size];
        int j = 0;
        while (j < size) {
            scene_parameter.preview_image[j] = new Color(scene.preview_image[j].getRGB());
            ++j;
        }
    }

    private void copySceneParameters(SceneParameter sour, SceneParameter dest) {
        dest.size[0] = sour.size[0];
        dest.size[1] = sour.size[1];
        int i = 0;
        while (i < 5) {
            dest.genertator_types[i] = sour.genertator_types[i];
            dest.generator_parameters[i] = sour.generator_parameters[i];
            dest.level_values[i] = sour.level_values[i];
            dest.speed_values[i] = sour.speed_values[i];
            dest.filter_modi[i] = sour.filter_modi[i];
            dest.mixer_modi[i] = sour.mixer_modi[i];
            ++i;
        }
        dest.effect_mode = sour.effect_mode;
        dest.effect_direction = sour.effect_direction;
        dest.effect_methode = sour.effect_methode;
        dest.effect_value = sour.effect_value;
        dest.effect_lower_limit = sour.effect_lower_limit;
        dest.effect_upper_limit = sour.effect_upper_limit;
        dest.effect_timer_value = sour.effect_timer_value;
        dest.effect_is_active = sour.effect_is_active;
        int size = dest.size[0] * dest.size[1];
        dest.preview_image = new Color[size];
        int j = 0;
        while (j < size) {
            dest.preview_image[j] = new Color(sour.preview_image[j].getRGB());
            ++j;
        }
        dest.scene_name = sour.scene_name;
    }
}

