/*
 * Decompiled with CFR 0.152.
 */
package Player;

import Main.GlediatorModel;
import Player.UDP_Receive_Timer_Task;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Player
extends JFrame {
    private static boolean is_recording;
    private static boolean is_playing;
    private static boolean file_loaded;
    private static int sx;
    private static int sy;
    private static long file_size;
    private static long frame;
    private static long num_frames;
    private static long curr_pos;
    private static byte[] buffer;
    private JFileChooser file_chooser;
    private static File file;
    private static FileOutputStream fop;
    private static FileInputStream fis;
    GlediatorModel glediator_model;
    private static final int INPUT_BUFFER_LENGTH = 100;
    private static final int RECEIVE_TIME_OUT = 20;
    private static final int UIB_PORT = 50200;
    private static final int MY_PORT = 50201;
    private static final int TRANSFER_BLOCK_SIZE = 1000;
    private static DatagramSocket socket;
    private static int loc_port;
    private static int rem_port;
    private static byte[] input_buffer;
    private static boolean socket_open;
    private static String sender;
    private Timer udp_receive_timer;
    private static JComboBox cb_slot;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private static JLabel lbl_a;
    private static JLabel lbl_b;
    private static JLabel lbl_sd_status;
    static JButton pb_connect;
    static JButton pb_load;
    static JButton pb_play;
    static JButton pb_rec;
    static JButton pb_stopp;
    static JButton pb_upload;
    private static JProgressBar pbar_sd_transfer;
    private static JSlider sl_progress;
    private static JTextField tf_uib_ip;

    public Player(GlediatorModel glediator_model) {
        this.initComponents();
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Icons/Logo.png")).getImage());
        this.glediator_model = glediator_model;
        this.file_chooser = new JFileChooser();
        file = null;
        fop = null;
        is_recording = false;
        is_playing = false;
        sx = 32;
        sy = 16;
        curr_pos = 0L;
        buffer = new byte[3];
        sender = "";
        input_buffer = new byte[100];
        loc_port = 50201;
        rem_port = 50200;
        try {
            socket = new DatagramSocket(null);
            socket.setReuseAddress(true);
            socket.setBroadcast(true);
            socket.bind(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), loc_port));
            socket_open = true;
        }
        catch (Exception ex) {
            System.out.println(ex);
            socket_open = false;
        }
        this.udp_receive_timer = new Timer();
        this.udp_receive_timer.schedule((TimerTask)new UDP_Receive_Timer_Task(), 100L, 20L);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        lbl_a = new JLabel();
        lbl_b = new JLabel();
        sl_progress = new JSlider();
        pb_play = new JButton();
        pb_stopp = new JButton();
        pb_rec = new JButton();
        pb_load = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel6 = new JLabel();
        tf_uib_ip = new JTextField();
        this.jLabel7 = new JLabel();
        cb_slot = new JComboBox();
        pbar_sd_transfer = new JProgressBar();
        pb_upload = new JButton();
        lbl_sd_status = new JLabel();
        pb_connect = new JButton();
        this.setTitle("Animation Player / Recorder");
        this.setBounds(new Rectangle(100, 100, 0, 0));
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                Player.this.formComponentShown(evt);
            }

            @Override
            public void componentHidden(ComponentEvent evt) {
                Player.this.formComponentHidden(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setLayout(new GridBagLayout());
        lbl_a.setText("---");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)lbl_a, gridBagConstraints);
        lbl_b.setText("---");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)lbl_b, gridBagConstraints);
        sl_progress.setPreferredSize(new Dimension(300, 29));
        sl_progress.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Player.this.sl_progressMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                Player.this.sl_progressMouseReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)sl_progress, gridBagConstraints);
        pb_play.setText("Play/Pause");
        pb_play.setActionCommand("Play");
        pb_play.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Player.this.pb_playActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)pb_play, gridBagConstraints);
        pb_stopp.setText("Stop");
        pb_stopp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Player.this.pb_stoppActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)pb_stopp, gridBagConstraints);
        pb_rec.setText("Rec");
        pb_rec.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Player.this.pb_recActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)pb_rec, gridBagConstraints);
        pb_load.setText("Load");
        pb_load.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Player.this.pb_loadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)pb_load, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 256;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel6.setText("UIB IP-Adresse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel6, gridBagConstraints);
        tf_uib_ip.setText("192.168.5.25");
        tf_uib_ip.setMinimumSize(new Dimension(40, 28));
        tf_uib_ip.setPreferredSize(new Dimension(40, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)tf_uib_ip, gridBagConstraints);
        this.jLabel7.setText("Slot on SD card");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)this.jLabel7, gridBagConstraints);
        cb_slot.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31", "32", "33", "34", "35", "36", "37", "38", "39", "40", "41", "42", "43", "44", "45", "46", "47", "48", "49", "50", "51", "52", "53", "54", "55", "56", "57", "58", "59", "60", "61", "62", "63", "64", "65", "66", "67", "68", "69", "70", "71", "72", "73", "74", "75", "76", "77", "78", "79", "80", "81", "82", "83", "84", "85", "86", "87", "88", "89", "90", "91", "92", "93", "94", "95", "96", "97", "98", "99"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)cb_slot, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)pbar_sd_transfer, gridBagConstraints);
        pb_upload.setText("Start Upload");
        pb_upload.setEnabled(false);
        pb_upload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Player.this.pb_uploadActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)pb_upload, gridBagConstraints);
        lbl_sd_status.setText("Not connected ...");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.jPanel2.add((Component)lbl_sd_status, gridBagConstraints);
        pb_connect.setText("Connect");
        pb_connect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Player.this.pb_connectActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)pb_connect, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
        this.udp_receive_timer = new Timer();
        this.udp_receive_timer.schedule((TimerTask)new UDP_Receive_Timer_Task(), 100L, 20L);
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.udp_receive_timer.cancel();
    }

    private void pb_recActionPerformed(ActionEvent evt) {
        int return_val = this.file_chooser.showSaveDialog(this);
        if (return_val == 0) {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (!(file = this.file_chooser.getSelectedFile()).exists()) {
                    file.createNewFile();
                }
                fop = new FileOutputStream(file);
                sx = this.glediator_model.getFrameSize()[0];
                sy = this.glediator_model.getFrameSize()[1];
                pb_play.setEnabled(false);
                pb_rec.setEnabled(false);
                pb_load.setEnabled(false);
                pb_connect.setEnabled(false);
                pb_upload.setEnabled(false);
                cb_slot.setEnabled(false);
                sl_progress.setEnabled(false);
                lbl_a.setText("Recording ...");
                this.glediator_model.setRecordingState(true);
                is_recording = true;
            }
            catch (Exception ex) {
                System.out.println(ex);
                this.glediator_model.setRecordingState(false);
                is_recording = false;
                pb_play.setEnabled(true);
                pb_rec.setEnabled(true);
                pb_load.setEnabled(true);
                pb_connect.setEnabled(true);
                pb_upload.setEnabled(true);
                cb_slot.setEnabled(true);
                sl_progress.setEnabled(true);
                lbl_a.setText("No file loaded.");
                lbl_b.setText("---");
            }
        }
        file_size = 0L;
        frame = 0L;
    }

    private void pb_stoppActionPerformed(ActionEvent evt) {
        if (is_recording) {
            try {
                fop.flush();
                fop.close();
                file = this.file_chooser.getSelectedFile();
                fis = new FileInputStream(file);
                lbl_a.setText("File open: '" + file.getName() + "'");
                num_frames = file.length() / (long)(3 * sx * sy);
                lbl_b.setText(num_frames + " Frames (" + file.length() / 1000L + "kB)");
                file_loaded = true;
            }
            catch (Exception ex) {
                System.out.println(ex);
                file_loaded = false;
                lbl_a.setText("No file loaded.");
                lbl_b.setText("---");
            }
            this.glediator_model.setRecordingState(false);
            is_recording = false;
        }
        if (is_playing || this.glediator_model.getPlayingState()) {
            is_playing = false;
            this.glediator_model.setPlayingState(false);
            sl_progress.setValue(0);
            try {
                fis.close();
                fis = new FileInputStream(file);
                lbl_a.setText("File open: '" + file.getName() + "'");
                lbl_b.setText(num_frames + " Frames (" + file.length() / 1000L + "kB)");
                file_loaded = true;
            }
            catch (Exception ex) {
                System.out.println(ex);
                lbl_a.setText("No file loaded.");
                lbl_a.setText("---");
                file_loaded = false;
            }
        }
        pb_play.setEnabled(true);
        pb_rec.setEnabled(true);
        pb_load.setEnabled(true);
        pb_connect.setEnabled(true);
        cb_slot.setEnabled(true);
        sl_progress.setEnabled(true);
        sl_progress.setValue(0);
        frame = 0L;
    }

    private void pb_playActionPerformed(ActionEvent evt) {
        if (file_loaded) {
            sx = this.glediator_model.getFrameSize()[0];
            sy = this.glediator_model.getFrameSize()[1];
            if (is_playing) {
                is_playing = false;
            } else {
                is_playing = true;
                this.glediator_model.setPlayingState(true);
            }
            pb_load.setEnabled(false);
            pb_rec.setEnabled(false);
            pb_connect.setEnabled(false);
            pb_upload.setEnabled(false);
            cb_slot.setEnabled(false);
        }
    }

    private void pb_loadActionPerformed(ActionEvent evt) {
        int return_val = this.file_chooser.showOpenDialog(this);
        sx = this.glediator_model.getFrameSize()[0];
        sy = this.glediator_model.getFrameSize()[1];
        if (return_val == 0) {
            try {
                file = this.file_chooser.getSelectedFile();
                fis = new FileInputStream(file);
                lbl_a.setText("File open: '" + file.getName() + "'");
                file_size = file.length();
                num_frames = file.length() / (long)(3 * sx * sy);
                lbl_b.setText(num_frames + " Frames (" + file.length() / 1000L + "kB)");
                file_loaded = true;
            }
            catch (Exception ex) {
                System.out.println(ex);
                lbl_a.setText("Stoped ...");
                lbl_a.setText("---");
                file_loaded = false;
            }
            sl_progress.setValue(0);
            frame = 0L;
            curr_pos = 0L;
        }
    }

    private void sl_progressMouseReleased(MouseEvent evt) {
        if (file_loaded && this.glediator_model.getPlayingState()) {
            is_playing = false;
            try {
                fis.close();
                fis = new FileInputStream(file);
                int pos = sl_progress.getValue();
                long frames_to_skip = frame = (long)((int)(num_frames * (long)pos / 100L));
                long bytes_to_skip = frames_to_skip * 3L * (long)sx * (long)sy;
                fis.skip(bytes_to_skip);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            is_playing = true;
        }
    }

    private void sl_progressMousePressed(MouseEvent evt) {
        is_playing = false;
    }

    private void pb_connectActionPerformed(ActionEvent evt) {
        Player.request_current_para();
    }

    private void pb_uploadActionPerformed(ActionEvent evt) {
        pb_load.setEnabled(false);
        pb_rec.setEnabled(false);
        pb_play.setEnabled(false);
        pb_stopp.setEnabled(false);
        pb_connect.setEnabled(false);
        pb_upload.setEnabled(false);
        cb_slot.setEnabled(false);
        is_playing = false;
        this.glediator_model.setPlayingState(false);
        Player.prepare_file_transfer();
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Player.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex2) {
            Logger.getLogger(Player.class.getName()).log(Level.SEVERE, null, ex2);
        }
        catch (IllegalAccessException ex3) {
            Logger.getLogger(Player.class.getName()).log(Level.SEVERE, null, ex3);
        }
        catch (UnsupportedLookAndFeelException ex4) {
            Logger.getLogger(Player.class.getName()).log(Level.SEVERE, null, ex4);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    private static void request_current_para() {
        System.out.println();
        System.out.println();
        System.out.println("Sending Main Para Request");
        byte[] byArray = new byte[9];
        byArray[0] = -100;
        byArray[1] = -64;
        byArray[3] = 4;
        byArray[5] = 1;
        byArray[6] = 64;
        byArray[8] = 54;
        byte[] buf = byArray;
        sender = "PARA_REQUEST";
        lbl_sd_status.setText("Connecting to UIB ...");
        Player.send_udp(buf, tf_uib_ip.getText(), rem_port);
    }

    private static void prepare_file_transfer() {
        System.out.println();
        System.out.println();
        System.out.println("Sending Prepare File Request");
        byte[] byArray = new byte[10];
        byArray[0] = -100;
        byArray[1] = -64;
        byArray[3] = 5;
        byArray[5] = 1;
        byArray[6] = 64;
        byArray[7] = 3;
        byArray[8] = (byte)cb_slot.getSelectedIndex();
        byArray[9] = 54;
        byte[] buf = byArray;
        sender = "PREPARE_FILE_TRANSFER";
        lbl_sd_status.setText("Preparing File Transfer ...");
        Player.send_udp(buf, tf_uib_ip.getText(), rem_port);
    }

    private static void send_data_block() {
        byte[] buf = new byte[1009];
        buf[0] = -100;
        buf[1] = -64;
        buf[4] = 0;
        buf[5] = 1;
        buf[6] = -64;
        buf[7] = 6;
        int result = -1;
        int block_size = 1000;
        if (file_size - curr_pos < 1000L) {
            block_size = (int)(file_size - curr_pos);
        }
        try {
            result = fis.read(buf, 8, block_size);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        int fs = block_size;
        buf[2] = (byte)(fs >> 8 & 0xFF);
        buf[3] = (byte)(fs & 0xFF);
        buf[1008] = 54;
        if (result != -1) {
            pbar_sd_transfer.setValue((int)((curr_pos += (long)block_size) * 100L / file_size));
            sender = "SEND_DATA_BLOCK";
            lbl_sd_status.setText("Sending Data to UIB");
            Player.send_udp(buf, tf_uib_ip.getText(), rem_port);
        } else {
            curr_pos = 0L;
            pbar_sd_transfer.setValue(0);
            lbl_sd_status.setText("Error reading file");
            try {
                fis.close();
                fis = new FileInputStream(file);
            }
            catch (Exception ex2) {
                System.out.println(ex2);
            }
        }
    }

    private static void finish_file_transfer() {
        System.out.println();
        System.out.println();
        System.out.println("Sending Finish File Transfer Request");
        byte[] byArray = new byte[9];
        byArray[0] = -100;
        byArray[1] = -64;
        byArray[3] = 5;
        byArray[5] = 1;
        byArray[6] = 64;
        byArray[7] = 5;
        byArray[8] = 54;
        byte[] buf = byArray;
        sender = "FINISH_FILE_TRANSFER";
        lbl_sd_status.setText("Finishing File Transfer ...");
        Player.send_udp(buf, tf_uib_ip.getText(), rem_port);
    }

    private static void send_udp(byte[] _buf, String _ip, int _dest_port) {
        try {
            InetAddress address = InetAddress.getByName(_ip);
            DatagramPacket packet = new DatagramPacket(_buf, _buf.length, address, _dest_port);
            socket.send(packet);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public static void receive_udp() {
        block16: {
            if (socket_open) {
                try {
                    DatagramPacket packet = new DatagramPacket(input_buffer, input_buffer.length);
                    socket.setSoTimeout(10);
                    socket.receive(packet);
                    if (packet.getLength() != 0) {
                        System.out.println("Received UDP packet at system time " + System.currentTimeMillis() + " (Millis).");
                        System.out.println("Packet length: " + packet.getLength());
                        if (input_buffer[0] == -100) {
                            System.out.println("It's a TMP2.Net packtet.");
                            if (input_buffer[1] == -83) {
                                System.out.println("It's an answer containing data.");
                                if (sender.equals("PARA_REQUEST")) {
                                    System.out.println("It's the answer to a Parameter request.");
                                    int index = 54;
                                    int sd_init_succesfull = input_buffer[54] & 0xFF;
                                    if (sd_init_succesfull == 0) {
                                        lbl_sd_status.setText("SD card on UIB not initialized.");
                                        pb_upload.setEnabled(false);
                                    } else {
                                        lbl_sd_status.setText("SD card on UIB OK");
                                        if (file_loaded) {
                                            pb_upload.setEnabled(true);
                                        }
                                        pbar_sd_transfer.setValue(0);
                                    }
                                    return;
                                }
                            }
                            if (input_buffer[1] == -84) {
                                System.out.println("It's an answer without data.");
                                if (sender.equals("PREPARE_FILE_TRANSFER")) {
                                    System.out.println("It's the answer to a PREPARE_FILE_TRANSFER request.");
                                    lbl_sd_status.setText("File Transfer initialized ...");
                                    Player.send_data_block();
                                    return;
                                }
                                if (sender.equals("SEND_DATA_BLOCK")) {
                                    System.out.println("It's the answer to a SEND_DATA_BLOCK.");
                                    lbl_sd_status.setText("Frame was received ...");
                                    if (curr_pos < file_size) {
                                        Player.send_data_block();
                                    } else {
                                        Player.finish_file_transfer();
                                    }
                                    return;
                                }
                                if (sender.equals("FINISH_FILE_TRANSFER")) {
                                    System.out.println("It's the answer to a FINISH_FILE_TRANSFER request.");
                                    lbl_sd_status.setText("File transfer finished.");
                                    pb_load.setEnabled(true);
                                    pb_rec.setEnabled(true);
                                    pb_play.setEnabled(true);
                                    pb_stopp.setEnabled(true);
                                    pb_connect.setEnabled(true);
                                    pb_upload.setEnabled(true);
                                    cb_slot.setEnabled(true);
                                    fis.close();
                                    fis = new FileInputStream(file);
                                    frame = 0L;
                                }
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    if (ex.getMessage().equals("Receive timed out")) break block16;
                    System.out.println(ex);
                }
            }
        }
    }

    public void saveFrame(Color[] image) {
        try {
            int y = 0;
            while (y < sy) {
                int x = 0;
                while (x < sx) {
                    int index = y * sx + x;
                    Player.buffer[0] = (byte)image[index].getRed();
                    Player.buffer[1] = (byte)image[index].getGreen();
                    Player.buffer[2] = (byte)image[index].getBlue();
                    fop.write(buffer);
                    ++x;
                }
                ++y;
            }
            lbl_b.setText("Frame: " + ++frame + ", File size: " + (file_size += (long)(sx * sy * 3)) / 1000L + " kB");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    public void readFrame(Color[] image) {
        if (is_playing) {
            try {
                int result = -1;
                int y = 0;
                while (y < sy) {
                    int x = 0;
                    while (x < sx) {
                        int index = y * sx + x;
                        result = fis.read(buffer);
                        if (result == -1) break;
                        image[index] = new Color(buffer[0] & 0xFF, buffer[1] & 0xFF, buffer[2] & 0xFF);
                        ++x;
                    }
                    if (result == -1) {
                        fis.close();
                        fis = new FileInputStream(file);
                        frame = 0L;
                        break;
                    }
                    ++y;
                }
                lbl_b.setText("Frame " + ++frame + " of " + num_frames);
                sl_progress.setValue((int)(frame * 100L / num_frames));
            }
            catch (Exception ex) {
                System.out.println(ex);
                is_playing = false;
                this.glediator_model.setPlayingState(false);
                sl_progress.setValue(0);
                frame = 0L;
            }
        }
    }
}

