/*
 * Decompiled with CFR 0.152.
 */
package Output;

import java.awt.Color;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class TPM2NetOutput {
    DatagramSocket tpm2_socket;
    InetAddress dest_ip;
    private int size_x;
    private int size_y;
    private int tpm2_port = 65506;
    private byte[] frame_rgb;
    private int sequence = 1;
    private byte[] output_buffer = new byte[1208];
    private byte[] data_buffer;
    private boolean socket_open = false;
    private static final int TPM2_NET_HEADER_LENGTH = 6;
    private static final int TPM2_NET_MAX_PACKET_PAYLOAD_SIZE = 1200;

    public String startTPM2_Net(String dest_ip) {
        String status;
        try {
            this.tpm2_socket = new DatagramSocket(this.tpm2_port);
            status = "TPM2.Net socket open.";
            this.socket_open = true;
        }
        catch (SocketException ex) {
            System.out.println(ex);
            status = "Failed to open TPM2.Net socket!";
            this.socket_open = false;
        }
        try {
            this.dest_ip = InetAddress.getByName(dest_ip);
            System.out.print("Destination IP Address:");
            System.out.println(dest_ip.toString());
        }
        catch (UnknownHostException ex) {
            System.out.println(ex);
        }
        return status;
    }

    public String stopTPM2_Net() {
        String status;
        System.out.println("Attempting to close socket");
        if (this.socket_open) {
            this.tpm2_socket.close();
            status = "TPM2.Net socket closed.";
            this.socket_open = false;
        } else {
            status = "TPM2.Net socket allready closed!";
        }
        return status;
    }

    public void set_parameters(int x_size, int y_size) {
        System.out.print("X width: ");
        System.out.println(x_size);
        System.out.print("Y height: ");
        System.out.println(y_size);
        this.size_x = x_size;
        this.size_y = y_size;
        this.frame_rgb = new byte[this.size_x * this.size_y * 3];
    }

    public boolean get_TPM2_Status() {
        return this.socket_open;
    }

    public void send_out_one_frame(Color[] frame) {
        if (this.socket_open) {
            int x = 0;
            while (x < this.size_x) {
                int y = 0;
                while (y < this.size_y) {
                    int index = y * this.size_x + x;
                    this.frame_rgb[3 * index + 0] = (byte)frame[index].getRed();
                    this.frame_rgb[3 * index + 1] = (byte)frame[index].getGreen();
                    this.frame_rgb[3 * index + 2] = (byte)frame[index].getBlue();
                    ++y;
                }
                ++x;
            }
            int packets_required = (int)Math.ceil((double)this.frame_rgb.length / 1200.0);
            System.out.println((double)this.frame_rgb.length / 1200.0);
            System.out.print("Going to need packets:");
            System.out.println(packets_required);
            byte[] payload = new byte[1200];
            int payload_len = 1200;
            System.out.println("Sending Frame");
            System.out.print("Need to send ");
            System.out.print(this.frame_rgb.length);
            System.out.println(" bytes");
            int packet_num = 0;
            while (packet_num < packets_required) {
                System.out.print("Packet ");
                System.out.println(packet_num);
                System.out.print("Starting a the following position: ");
                System.out.println(packet_num * 1200);
                if (packet_num < packets_required - 1) {
                    System.arraycopy(this.frame_rgb, packet_num * 1200, payload, 0, 1200);
                } else {
                    System.out.println("Last Packet!");
                    payload_len = this.frame_rgb.length - packet_num * 1200;
                    System.arraycopy(this.frame_rgb, packet_num * 1200, payload, 0, payload_len);
                }
                System.out.print("Payload size: ");
                System.out.println(payload_len);
                this.send_out_tpm2_packet(this.dest_ip, 0, packets_required, packet_num, payload_len, payload);
                ++packet_num;
            }
        }
    }

    private void send_out_tpm2_packet(InetAddress node_ip, int universeID, int total_packet_count, int seq_num, int length, byte[] data) {
        this.output_buffer[0] = -100;
        this.output_buffer[1] = -38;
        this.output_buffer[2] = (byte)(length >> 8 & 0xFF);
        this.output_buffer[3] = (byte)(length & 0xFF);
        this.output_buffer[4] = (byte)seq_num;
        this.output_buffer[5] = (byte)total_packet_count;
        System.arraycopy(data, 0, this.output_buffer, 6, length);
        this.output_buffer[6 + length] = 54;
        DatagramPacket tpm2_packet = new DatagramPacket(this.output_buffer, length + 6 + 1, node_ip, this.tpm2_port);
        try {
            this.tpm2_socket.send(tpm2_packet);
        }
        catch (IOException ex) {
            System.out.println(ex);
        }
    }
}

