/*
 * Decompiled with CFR 0.152.
 */
package Output;

import Output.BaudRate;
import com.fazecast.jSerialComm.SerialPort;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class SerialOutput {
    private List<SerialPort> serialPortList;
    private SerialPort[] serialPorts;
    private Enumeration enumComm;
    private SerialPort serialPort;
    private OutputStream outputStream;
    private boolean port_open = false;

    SerialOutput() {
    }

    public String[] getComPorts() {
        ArrayList<String> ports = new ArrayList<String>();
        String[] com_port_list = new String[]{};
        try {
            this.serialPorts = SerialPort.getCommPorts();
            this.serialPortList = Arrays.asList(this.serialPorts);
            this.enumComm = Collections.enumeration(this.serialPortList);
            int index = 0;
            while (this.enumComm.hasMoreElements()) {
                this.serialPort = (SerialPort)this.enumComm.nextElement();
                ports.add(this.serialPort.getSystemPortName());
                ++index;
            }
            System.out.println("Number of COM ports found: " + index);
            String[] found_ports = new String[index];
            int i = 0;
            while (i < index) {
                found_ports[i] = (String)ports.get(i);
                ++i;
            }
            return found_ports;
        }
        catch (UnsatisfiedLinkError err) {
            System.out.println("It seems like you don't have any RXTX binary in your Glediator folder nor elsewhere!");
            return new String[0];
        }
    }

    public String startSerial(String com_port, BaudRate baud_rate) {
        String status = String.valueOf(com_port) + " started";
        boolean foundPort = false;
        if (this.port_open) {
            status = "Serial Port allready opend!";
        } else {
            this.serialPorts = SerialPort.getCommPorts();
            this.serialPortList = Arrays.asList(this.serialPorts);
            this.enumComm = Collections.enumeration(this.serialPortList);
            while (this.enumComm.hasMoreElements()) {
                this.serialPort = (SerialPort)this.enumComm.nextElement();
                String portName = com_port;
                if (!portName.contentEquals(this.serialPort.getSystemPortName())) continue;
                foundPort = true;
                break;
            }
            if (!foundPort) {
                status = "Serial Port not found!";
            } else {
                try {
                    this.serialPort.openPort(500);
                    this.port_open = true;
                }
                catch (Exception e) {
                    status = "Serial Port occupied!";
                    this.port_open = false;
                }
                this.outputStream = this.serialPort.getOutputStream();
                try {
                    int br_i = 0;
                    switch (baud_rate) {
                        case B_115200: {
                            br_i = 115200;
                            break;
                        }
                        case B_230400: {
                            br_i = 230400;
                            break;
                        }
                        case B_250000: {
                            br_i = 250000;
                            break;
                        }
                        case B_500000: {
                            br_i = 500000;
                            break;
                        }
                        case B_921600: {
                            br_i = 921600;
                            break;
                        }
                        case B_1000000: {
                            br_i = 1000000;
                            break;
                        }
                        case B_1250000: {
                            br_i = 1250000;
                        }
                    }
                    this.serialPort.setComPortParameters(br_i, 8, 1, 0);
                }
                catch (Exception e3) {
                    status = "Could not set interface parameters!";
                    this.port_open = false;
                }
            }
        }
        return status;
    }

    public String stopSerial(String _comport) {
        String status;
        if (this.port_open) {
            try {
                this.serialPort.closePort();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            this.port_open = false;
            status = String.valueOf(_comport) + " closed!";
        } else {
            status = String.valueOf(_comport) + " allready closed!";
        }
        return status;
    }

    public void sendSerialData(byte[] output_buffer, int size) {
        if (this.port_open) {
            try {
                this.outputStream.write(output_buffer, 0, size);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

