/*
 * Decompiled with CFR 0.152.
 */
package Mixer;

import java.awt.Color;

public class Mixer {
    private MixerMode mixer_mode = MixerMode.ADD;

    public void setMixerMode(MixerMode mixer_mode) {
        this.mixer_mode = mixer_mode;
    }

    public MixerMode getMixerMode() {
        return this.mixer_mode;
    }

    public void do_mixing(Color[] image_a, Color[] image_b, Color[] image_sum) {
        switch (this.mixer_mode) {
            case ADD: {
                this.mixAdd(image_a, image_b, image_sum);
                break;
            }
            case SUBSTRACT: {
                this.mixSubstract(image_a, image_b, image_sum);
                break;
            }
            case MULTIPLY: {
                this.mixMultiply(image_a, image_b, image_sum);
                break;
            }
            case DIVIDE: {
                this.mixDevide(image_a, image_b, image_sum);
                break;
            }
            case DIFFERENCE: {
                this.mixDifference(image_a, image_b, image_sum);
                break;
            }
            case AND: {
                this.mixAnd(image_a, image_b, image_sum);
                break;
            }
            case OR: {
                this.mixOr(image_a, image_b, image_sum);
                break;
            }
            case XOR: {
                this.mixXor(image_a, image_b, image_sum);
            }
        }
    }

    private void mixAdd(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = image_a[i].getRed() + image_b[i].getRed();
            int g = image_a[i].getGreen() + image_b[i].getGreen();
            int b = image_a[i].getBlue() + image_b[i].getBlue();
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixSubstract(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = image_a[i].getRed() - image_b[i].getRed();
            int g = image_a[i].getGreen() - image_b[i].getGreen();
            int b = image_a[i].getBlue() - image_b[i].getBlue();
            if (r < 0) {
                r = 0;
            }
            if (g < 0) {
                g = 0;
            }
            if (b < 0) {
                b = 0;
            }
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixMultiply(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = (int)((float)(image_a[i].getRed() * image_b[i].getRed()) / 255.0f);
            int g = (int)((float)(image_a[i].getGreen() * image_b[i].getGreen()) / 255.0f);
            int b = (int)((float)(image_a[i].getBlue() * image_b[i].getBlue()) / 255.0f);
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixDevide(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = image_b[i].getRed() != 0 ? Math.round((float)image_a[i].getRed() / (float)image_b[i].getRed()) : 255;
            int g = image_b[i].getGreen() != 0 ? Math.round((float)image_a[i].getGreen() / (float)image_b[i].getGreen()) : 255;
            int b = image_b[i].getBlue() != 0 ? Math.round((float)image_a[i].getBlue() / (float)image_b[i].getBlue()) : 255;
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixDifference(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = Math.abs(image_a[i].getRed() - image_b[i].getRed());
            int g = Math.abs(image_a[i].getGreen() - image_b[i].getGreen());
            int b = Math.abs(image_a[i].getBlue() - image_b[i].getBlue());
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixAnd(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int b;
            int g;
            int r;
            if (image_a[i].getRed() > 0 && image_b[i].getRed() > 0) {
                r = image_a[i].getRed() + image_b[i].getRed();
                if (r > 255) {
                    r = 255;
                }
            } else {
                r = 0;
            }
            if (image_a[i].getGreen() > 0 && image_b[i].getGreen() > 0) {
                g = image_a[i].getGreen() + image_b[i].getGreen();
                if (g > 255) {
                    g = 255;
                }
            } else {
                g = 0;
            }
            if (image_a[i].getBlue() > 0 && image_b[i].getBlue() > 0) {
                b = image_a[i].getBlue() + image_b[i].getBlue();
                if (b > 255) {
                    b = 255;
                }
            } else {
                b = 0;
            }
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixOr(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int b;
            int g;
            int r;
            if (image_a[i].getRed() > 0 || image_b[i].getRed() > 0) {
                r = image_a[i].getRed() + image_b[i].getRed();
                if (r > 255) {
                    r = 255;
                }
            } else {
                r = 0;
            }
            if (image_a[i].getGreen() > 0 || image_b[i].getGreen() > 0) {
                g = image_a[i].getGreen() + image_b[i].getGreen();
                if (g > 255) {
                    g = 255;
                }
            } else {
                g = 0;
            }
            if (image_a[i].getBlue() > 0 || image_b[i].getBlue() > 0) {
                b = image_a[i].getBlue() + image_b[i].getBlue();
                if (b > 255) {
                    b = 255;
                }
            } else {
                b = 0;
            }
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void mixXor(Color[] image_a, Color[] image_b, Color[] image_sum) {
        int frame_size = image_a.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int b;
            int g;
            int r;
            if (image_a[i].getRed() > 0 ^ image_b[i].getRed() > 0) {
                r = image_a[i].getRed() + image_b[i].getRed();
                if (r > 255) {
                    r = 255;
                }
            } else {
                r = 0;
            }
            if (image_a[i].getGreen() > 0 ^ image_b[i].getGreen() > 0) {
                g = image_a[i].getGreen() + image_b[i].getGreen();
                if (g > 255) {
                    g = 255;
                }
            } else {
                g = 0;
            }
            if (image_a[i].getBlue() > 0 ^ image_b[i].getBlue() > 0) {
                b = image_a[i].getBlue() + image_b[i].getBlue();
                if (b > 255) {
                    b = 255;
                }
            } else {
                b = 0;
            }
            image_sum[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    public static enum MixerMode {
        ADD("Add"),
        SUBSTRACT("Substract"),
        MULTIPLY("Multiply"),
        DIVIDE("Divide"),
        DIFFERENCE("Difference"),
        AND("AND"),
        OR("OR"),
        XOR("XOR");

        private final String displayed_text;

        private MixerMode(String s) {
            this.displayed_text = s;
        }

        public String toString() {
            return this.displayed_text;
        }
    }
}

