/*
 * Decompiled with CFR 0.152.
 */
package Mapper;

import Mapper.MappingOrder;
import Mapper.MappingType;
import Options.Options;
import java.awt.Color;

public class Mapper {
    int[] output_buffer_lut = new int[512];
    Color[] temp_image;

    public void setMapping(Options options) {
        int sx = options.getMatrixSize()[0];
        int sy = options.getMatrixSize()[1];
        int size = sx * sy;
        this.output_buffer_lut = new int[size];
        this.temp_image = new Color[size];
        MappingType mapping_type = options.getMappingType();
        switch (mapping_type) {
            case SINGLE_PIXELS: {
                MappingOrder pixel_order = options.getPixelOrder();
                this.do_pixel_mapping(this.output_buffer_lut, pixel_order, sx, sy);
                break;
            }
            case BOARDS_OF_PIXEL: {
                this.do_board_and_pixel_mapping(options.getMatrixSize(), options.getBoardOrder(), options.getPixelOrder(), options.getBoardSize()[0], options.getBoardSize()[1], options.getNumberOfBoards()[0], options.getNumberOfBoards()[1]);
            }
        }
    }

    public void doMapping(Color[] image_in, Color[] image_out) {
        int frame_size = image_in.length;
        int i = 0;
        while (i < frame_size) {
            image_out[i] = image_in[this.output_buffer_lut[i]];
            ++i;
        }
    }

    private void do_board_and_pixel_mapping(int[] _frame_size, MappingOrder _board_order, MappingOrder _pixel_order, int _pixels_per_board_x, int _pixels_per_board_y, int _num_pieces_x, int _num_pieces_y) {
        int y;
        int[] board_pixel_lut = new int[_pixels_per_board_x * _pixels_per_board_y];
        int[] matrix_board_lut = new int[_num_pieces_x * _num_pieces_y];
        int[] actual_board = new int[_pixels_per_board_x * _pixels_per_board_y];
        int x = 0;
        while (x < _pixels_per_board_x) {
            y = 0;
            while (y < _pixels_per_board_y) {
                board_pixel_lut[y * _pixels_per_board_x + x] = y * _pixels_per_board_x + x;
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < _num_pieces_x) {
            y = 0;
            while (y < _num_pieces_y) {
                matrix_board_lut[y * _num_pieces_x + x] = y * _num_pieces_x + x;
                ++y;
            }
            ++x;
        }
        this.do_pixel_mapping(board_pixel_lut, _pixel_order, _pixels_per_board_x, _pixels_per_board_y);
        this.do_pixel_mapping(matrix_board_lut, _board_order, _num_pieces_x, _num_pieces_y);
        int i = 0;
        while (i < _num_pieces_x * _num_pieces_y) {
            int actual_board_index = matrix_board_lut[i];
            int actual_y_pos_of_board = actual_board_index / _num_pieces_x;
            int actual_x_pos_of_board = actual_board_index % _num_pieces_x;
            int actual_offset_x = actual_x_pos_of_board * _pixels_per_board_x;
            int actual_offset_y = actual_y_pos_of_board * _pixels_per_board_y;
            int x2 = 0;
            while (x2 < _pixels_per_board_x) {
                int y2 = 0;
                while (y2 < _pixels_per_board_y) {
                    actual_board[y2 * _pixels_per_board_x + x2] = (actual_offset_y + y2) * _frame_size[0] + actual_offset_x + x2;
                    ++y2;
                }
                ++x2;
            }
            int j = 0;
            while (j < _pixels_per_board_x * _pixels_per_board_y) {
                this.output_buffer_lut[i * _pixels_per_board_x * _pixels_per_board_y + j] = actual_board[board_pixel_lut[j]];
                ++j;
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void do_pixel_mapping(int[] LUT, MappingOrder mapping_order, int size_x, int size_y) {
        boolean dir_x = false;
        boolean dir_y = false;
        int x = 0;
        int y = 0;
        Order order = Order.SNAKE;
        Orientation orientation = Orientation.HORIZONTAL;
        switch (mapping_order) {
            case HS_TL: {
                dir_x = true;
                dir_y = true;
                x = 0;
                y = 0;
                order = Order.SNAKE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case HS_TR: {
                dir_x = false;
                dir_y = true;
                x = size_x - 1;
                y = 0;
                order = Order.SNAKE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case HS_BL: {
                dir_x = true;
                dir_y = false;
                x = 0;
                y = size_y - 1;
                order = Order.SNAKE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case HS_BR: {
                dir_x = false;
                dir_y = false;
                x = size_x - 1;
                y = size_y - 1;
                order = Order.SNAKE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case VS_TL: {
                dir_x = true;
                dir_y = true;
                x = 0;
                y = 0;
                order = Order.SNAKE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case VS_TR: {
                dir_x = false;
                dir_y = true;
                x = size_x - 1;
                y = 0;
                order = Order.SNAKE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case VS_BL: {
                dir_x = true;
                dir_y = false;
                x = 0;
                y = size_y - 1;
                order = Order.SNAKE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case VS_BR: {
                dir_x = false;
                dir_y = false;
                x = size_x - 1;
                y = size_y - 1;
                order = Order.SNAKE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case HL_TL: {
                dir_x = true;
                dir_y = true;
                x = 0;
                y = 0;
                order = Order.LINE_WISE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case HL_TR: {
                dir_x = false;
                dir_y = true;
                x = size_x - 1;
                y = 0;
                order = Order.LINE_WISE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case HL_BL: {
                dir_x = true;
                dir_y = false;
                x = 0;
                y = size_y - 1;
                order = Order.LINE_WISE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case HL_BR: {
                dir_x = false;
                dir_y = false;
                x = size_x - 1;
                y = size_y - 1;
                order = Order.LINE_WISE;
                orientation = Orientation.HORIZONTAL;
                break;
            }
            case VL_TL: {
                dir_x = true;
                dir_y = true;
                x = 0;
                y = 0;
                order = Order.LINE_WISE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case VL_TR: {
                dir_x = false;
                dir_y = true;
                x = size_x - 1;
                y = 0;
                order = Order.LINE_WISE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case VL_BL: {
                dir_x = true;
                dir_y = false;
                x = 0;
                y = size_y - 1;
                order = Order.LINE_WISE;
                orientation = Orientation.VERTICAL;
                break;
            }
            case VL_BR: {
                dir_x = false;
                dir_y = false;
                x = size_x - 1;
                y = size_y - 1;
                order = Order.LINE_WISE;
                orientation = Orientation.VERTICAL;
                break;
            }
        }
        int i = 0;
        while (i < size_x * size_y) {
            LUT[i] = y * size_x + x;
            switch (orientation) {
                case HORIZONTAL: {
                    if (dir_x) {
                        ++x;
                        break;
                    }
                    --x;
                    break;
                }
                case VERTICAL: {
                    if (dir_y) {
                        ++y;
                        break;
                    }
                    --y;
                    break;
                }
            }
            block22 : switch (order) {
                case SNAKE: {
                    switch (orientation) {
                        case HORIZONTAL: {
                            if (x == size_x) {
                                dir_x = false;
                                x = size_x - 1;
                                y = dir_y ? ++y : --y;
                            }
                            if (x != -1) break block22;
                            dir_x = true;
                            x = 0;
                            if (dir_y) {
                                ++y;
                                break;
                            }
                            --y;
                            break;
                        }
                        case VERTICAL: {
                            if (y == size_y) {
                                dir_y = false;
                                y = size_y - 1;
                                x = dir_x ? ++x : --x;
                            }
                            if (y != -1) break block22;
                            dir_y = true;
                            y = 0;
                            if (dir_x) {
                                ++x;
                                break;
                            }
                            --x;
                        }
                    }
                    break;
                }
                case LINE_WISE: {
                    switch (orientation) {
                        case HORIZONTAL: {
                            if (x == size_x) {
                                x = 0;
                                y = dir_y ? ++y : --y;
                            }
                            if (x != -1) break;
                            x = size_x - 1;
                            if (dir_y) {
                                ++y;
                                break;
                            }
                            --y;
                            break;
                        }
                        case VERTICAL: {
                            if (y == size_y) {
                                y = 0;
                                x = dir_x ? ++x : --x;
                            }
                            if (y != -1) break;
                            y = size_y - 1;
                            if (dir_x) {
                                ++x;
                                break;
                            }
                            --x;
                        }
                    }
                    break;
                }
            }
            ++i;
        }
    }

    static enum Order {
        SNAKE,
        LINE_WISE;

    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

