/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.SuperGenerator;
import Generator.WaveOptions;
import java.awt.Color;

public class Wave
extends SuperGenerator {
    int wave_step_width = 1;
    String wave_dir = "Top";
    boolean wave_change_r = true;
    boolean wave_change_g = false;
    boolean wave_change_b = false;
    int wave_wave_lenght = 24;
    int wave_value_r = 255;
    int wave_value_g = 0;
    int wave_value_b = 0;
    int wave_counter = 0;
    WaveOptions options = null;

    public Wave(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public Wave(int[] _size, int _speed) {
        super("Wave;1;Right;false;true;false;150;0;0;0", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new WaveOptions(this);
        this.options.setVisible(true);
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }

    @Override
    void generateImage(Color[] image) {
        if (this.parameter_changed) {
            this.wave_step_width = Integer.parseInt(this.parameter_array[1]);
            this.wave_dir = this.parameter_array[2];
            this.wave_change_r = Boolean.parseBoolean(this.parameter_array[3]);
            this.wave_change_g = Boolean.parseBoolean(this.parameter_array[4]);
            this.wave_change_b = Boolean.parseBoolean(this.parameter_array[5]);
            this.wave_wave_lenght = Integer.parseInt(this.parameter_array[6]);
            this.wave_value_r = Integer.parseInt(this.parameter_array[7]);
            this.wave_value_g = Integer.parseInt(this.parameter_array[8]);
            this.wave_value_b = Integer.parseInt(this.parameter_array[9]);
            this.parameter_changed = false;
            this.options = null;
        }
        int ce = 0;
        this.wave_counter += this.wave_step_width;
        int x = 0;
        while (x < this.size[0]) {
            int y = 0;
            while (y < this.size[1]) {
                if (this.wave_dir.equals("Top Left")) {
                    ce = x + y + this.wave_counter;
                }
                if (this.wave_dir.equals("Top Right")) {
                    ce = x - y - this.wave_counter;
                }
                if (this.wave_dir.equals("Bottom Left")) {
                    ce = x - y + this.wave_counter;
                }
                if (this.wave_dir.equals("Bottom Right")) {
                    ce = x + y - this.wave_counter;
                }
                if (this.wave_dir.equals("Top")) {
                    ce = y + this.wave_counter;
                }
                if (this.wave_dir.equals("Bottom")) {
                    ce = y - this.wave_counter;
                }
                if (this.wave_dir.equals("Right")) {
                    ce = x - this.wave_counter;
                }
                if (this.wave_dir.equals("Left")) {
                    ce = x + this.wave_counter;
                }
                int r = this.wave_change_r ? (int)Math.ceil(255.0 - Math.abs(Math.sin((double)this.wave_wave_lenght / 200.0 * (double)ce / 31.0 * 3.1415)) * 255.0) : this.wave_value_r;
                int g = this.wave_change_g ? (int)Math.ceil(255.0 - Math.abs(Math.sin((double)this.wave_wave_lenght / 200.0 * (double)ce / 31.0 * 3.1415)) * 255.0) : this.wave_value_g;
                int b = this.wave_change_b ? (int)Math.ceil(255.0 - Math.abs(Math.sin((double)this.wave_wave_lenght / 200.0 * (double)ce / 31.0 * 3.1415)) * 255.0) : this.wave_value_b;
                image[y * this.size[0] + x] = new Color(r, g, b);
                ++y;
            }
            ++x;
        }
    }
}

