/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.SimpleSpectrumOptions;
import Generator.SuperGenerator;
import java.awt.Color;

public class SimpleSpectrum
extends SuperGenerator {
    String ss_position = "Bottom";
    int ss_gain = 2;
    int ss_red_start = 0;
    int ss_red_end = 255;
    int ss_green_start = 255;
    int ss_green_end = 0;
    int ss_blue_start = 0;
    int ss_blue_end = 0;
    SimpleSpectrumOptions options = null;

    public SimpleSpectrum(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public SimpleSpectrum(int[] _size, int _speed) {
        super("Simple Spectrum;Bottom;150;0;250;250;0;0;0", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new SimpleSpectrumOptions(this);
        this.options.setVisible(true);
    }

    @Override
    void generateImage(Color[] image) {
        int x2;
        int y2;
        int b;
        int g;
        int r;
        int y;
        int h2;
        int h;
        int x;
        if (this.parameter_changed) {
            this.ss_position = this.parameter_array[1].toString();
            this.ss_gain = Integer.parseInt(this.parameter_array[2]);
            this.ss_red_start = Integer.parseInt(this.parameter_array[3]);
            this.ss_red_end = Integer.parseInt(this.parameter_array[4]);
            this.ss_green_start = Integer.parseInt(this.parameter_array[5]);
            this.ss_green_end = Integer.parseInt(this.parameter_array[6]);
            this.ss_blue_start = Integer.parseInt(this.parameter_array[7]);
            this.ss_blue_end = Integer.parseInt(this.parameter_array[8]);
            this.parameter_changed = false;
            this.options = null;
        }
        if (this.ss_position.equals("Bottom")) {
            SimpleSpectrum.audio_properties.fft_binns = (int)((float)this.size[0] * 1.5f);
            x = 0;
            while (x < this.size[0]) {
                h = Math.round(SimpleSpectrum.audio_properties.fft[x] * (float)this.ss_gain);
                if (h > this.size[1] - 1) {
                    h = this.size[1] - 1;
                }
                h2 = this.size[1] - h - 1;
                y = 0;
                while (y < this.size[1]) {
                    if (y < h2 | h == 0) {
                        r = 0;
                        g = 0;
                        b = 0;
                    } else {
                        r = (int)((float)this.ss_red_start + (float)(this.size[1] - 1 - y) / (float)this.size[1] * (float)(this.ss_red_end - this.ss_red_start));
                        g = (int)((float)this.ss_green_start + (float)(this.size[1] - 1 - y) / (float)this.size[1] * (float)(this.ss_green_end - this.ss_green_start));
                        b = (int)((float)this.ss_blue_start + (float)(this.size[1] - 1 - y) / (float)this.size[1] * (float)(this.ss_blue_end - this.ss_blue_start));
                    }
                    image[y * this.size[0] + x] = new Color(r, g, b);
                    ++y;
                }
                ++x;
            }
        }
        if (this.ss_position.equals("Top")) {
            SimpleSpectrum.audio_properties.fft_binns = (int)((float)this.size[0] * 1.5f);
            x = 0;
            while (x < this.size[0]) {
                h = Math.round(SimpleSpectrum.audio_properties.fft[x] * (float)this.ss_gain);
                if (h > this.size[1] - 1) {
                    h = this.size[1] - 1;
                }
                h2 = h;
                y = 0;
                while (y < this.size[1]) {
                    if (y > h2 | h == 0) {
                        r = 0;
                        g = 0;
                        b = 0;
                    } else {
                        r = (int)((float)this.ss_red_start + (float)y / (float)this.size[1] * (float)(this.ss_red_end - this.ss_red_start));
                        g = (int)((float)this.ss_green_start + (float)y / (float)this.size[1] * (float)(this.ss_green_end - this.ss_green_start));
                        b = (int)((float)this.ss_blue_start + (float)y / (float)this.size[1] * (float)(this.ss_blue_end - this.ss_blue_start));
                    }
                    image[y * this.size[0] + x] = new Color(r, g, b);
                    ++y;
                }
                ++x;
            }
        }
        if (this.ss_position.equals("Right")) {
            SimpleSpectrum.audio_properties.fft_binns = (int)((float)this.size[1] * 1.5f);
            y2 = 0;
            while (y2 < this.size[1]) {
                h = Math.round(SimpleSpectrum.audio_properties.fft[y2] * (float)this.ss_gain);
                if (h > this.size[0] - 1) {
                    h = this.size[0] - 1;
                }
                h2 = this.size[0] - h - 1;
                x2 = 0;
                while (x2 < this.size[0]) {
                    if (x2 < h2 | h == 0) {
                        r = 0;
                        g = 0;
                        b = 0;
                    } else {
                        r = (int)((float)this.ss_red_start + (float)(this.size[0] - 1 - x2) / (float)this.size[0] * (float)(this.ss_red_end - this.ss_red_start));
                        g = (int)((float)this.ss_green_start + (float)(this.size[0] - 1 - x2) / (float)this.size[0] * (float)(this.ss_green_end - this.ss_green_start));
                        b = (int)((float)this.ss_blue_start + (float)(this.size[0] - 1 - x2) / (float)this.size[0] * (float)(this.ss_blue_end - this.ss_blue_start));
                    }
                    image[y2 * this.size[0] + x2] = new Color(r, g, b);
                    ++x2;
                }
                ++y2;
            }
        }
        if (this.ss_position.equals("Left")) {
            SimpleSpectrum.audio_properties.fft_binns = (int)((float)this.size[1] * 1.5f);
            y2 = 0;
            while (y2 < this.size[1]) {
                h = Math.round(SimpleSpectrum.audio_properties.fft[y2] * (float)this.ss_gain);
                if (h > this.size[0] - 1) {
                    h = this.size[0] - 1;
                }
                h2 = h;
                x2 = 0;
                while (x2 < this.size[0]) {
                    if (x2 > h2) {
                        r = 0;
                        g = 0;
                        b = 0;
                    } else {
                        r = (int)((float)this.ss_red_start + (float)x2 / (float)this.size[0] * (float)(this.ss_red_end - this.ss_red_start));
                        g = (int)((float)this.ss_green_start + (float)x2 / (float)this.size[0] * (float)(this.ss_green_end - this.ss_green_start));
                        b = (int)((float)this.ss_blue_start + (float)x2 / (float)this.size[0] * (float)(this.ss_blue_end - this.ss_blue_start));
                    }
                    image[y2 * this.size[0] + x2] = new Color(r, g, b);
                    ++x2;
                }
                ++y2;
            }
        }
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }
}

