/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.MetaBallsOptions;
import Generator.SuperGenerator;
import java.awt.Color;
import java.util.Random;

public class MetaBalls
extends SuperGenerator {
    int mb_r_start = 255;
    int mb_g_start = 0;
    int mb_b_start = 255;
    int mb_dia = 14;
    int mb_number = 4;
    int mb_speed = 1;
    boolean mb_random_color = false;
    int mb_random_time = 10;
    int[][] mb_vx = new int[4][32];
    int[][] mb_vy = new int[4][16];
    int[] mb_px;
    int[] mb_py;
    int[] mb_dx;
    int[] mb_dy;
    int mb_counter = 0;
    MetaBallsOptions options = null;

    public MetaBalls(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public MetaBalls(int[] _size, int _speed) {
        super("Meta Balls;255;0;255;5;7;1;true;20", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new MetaBallsOptions(this);
        this.options.setVisible(true);
    }

    @Override
    void generateImage(Color[] image) {
        int y;
        Random rnd = new Random();
        if (this.parameter_changed) {
            this.mb_r_start = Integer.parseInt(this.parameter_array[1]);
            this.mb_g_start = Integer.parseInt(this.parameter_array[2]);
            this.mb_b_start = Integer.parseInt(this.parameter_array[3]);
            this.mb_dia = Integer.parseInt(this.parameter_array[4]);
            this.mb_number = Integer.parseInt(this.parameter_array[5]);
            this.mb_speed = Integer.parseInt(this.parameter_array[6]);
            this.mb_random_color = Boolean.parseBoolean(this.parameter_array[7]);
            this.mb_random_time = Integer.parseInt(this.parameter_array[8]);
            this.mb_px = new int[this.mb_number];
            this.mb_py = new int[this.mb_number];
            this.mb_dx = new int[this.mb_number];
            this.mb_dy = new int[this.mb_number];
            this.mb_vx = new int[this.mb_number][this.size[0]];
            this.mb_vy = new int[this.mb_number][this.size[1]];
            int i = 0;
            while (i < this.mb_number) {
                this.mb_px[i] = (int)(rnd.nextDouble() * (double)this.size[0]);
                this.mb_py[i] = (int)(rnd.nextDouble() * (double)this.size[1]);
                this.mb_dx[i] = rnd.nextDouble() < 0.5 ? -1 : 1;
                this.mb_dy[i] = rnd.nextDouble() < 0.5 ? -1 : 1;
                ++i;
            }
            this.parameter_changed = false;
            this.options = null;
        }
        if (this.mb_random_color) {
            if (this.mb_counter > this.mb_random_time) {
                this.mb_r_start = rnd.nextInt(256);
                this.mb_g_start = rnd.nextInt(256);
                this.mb_b_start = rnd.nextInt(256);
                this.mb_counter = 0;
            } else {
                ++this.mb_counter;
            }
        }
        int j = 0;
        while (j < this.mb_number) {
            int n = j;
            this.mb_px[n] = this.mb_px[n] + this.mb_speed * this.mb_dx[j];
            int n2 = j;
            this.mb_py[n2] = this.mb_py[n2] + this.mb_speed * this.mb_dy[j];
            if (this.mb_px[j] < 0) {
                this.mb_dx[j] = 1;
            }
            if (this.mb_px[j] > this.size[0]) {
                this.mb_dx[j] = -1;
            }
            if (this.mb_py[j] < 0) {
                this.mb_dy[j] = 1;
            }
            if (this.mb_py[j] > this.size[1]) {
                this.mb_dy[j] = -1;
            }
            int x = 0;
            while (x < this.size[0]) {
                this.mb_vx[j][x] = (this.mb_px[j] - x) * (this.mb_px[j] - x);
                ++x;
            }
            y = 0;
            while (y < this.size[1]) {
                this.mb_vy[j][y] = (this.mb_py[j] - y) * (this.mb_py[j] - y);
                ++y;
            }
            ++j;
        }
        int x2 = 0;
        while (x2 < this.size[0]) {
            y = 0;
            while (y < this.size[1]) {
                Color temp_color;
                int R = 0;
                int G = 0;
                int B = 0;
                int k = 0;
                while (k < this.mb_number) {
                    double distance = this.mb_vx[k][x2] + this.mb_vy[k][y] + 1;
                    R += (int)((double)this.mb_dia / distance * (double)this.mb_r_start);
                    G += (int)((double)this.mb_dia / distance * (double)this.mb_g_start);
                    B += (int)((double)this.mb_dia / distance * (double)this.mb_b_start);
                    ++k;
                }
                if (R > 255) {
                    R = 255;
                }
                if (G > 255) {
                    G = 255;
                }
                if (B > 255) {
                    B = 255;
                }
                image[y * this.size[0] + x2] = temp_color = new Color(R, G, B);
                ++y;
            }
            ++x2;
        }
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }
}

