/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.KnightRiderOptions;
import Generator.SuperGenerator;
import java.awt.Color;

public class KnightRider
extends SuperGenerator {
    int kr_width = 1;
    int kr_segment_size = 2;
    int kr_length = 20;
    int kr_red = 255;
    int kr_green = 0;
    int kr_blue = 0;
    int kr_vert_pos = 50;
    int[] kr_intensities = new int[this.size[0]];
    int[] kr_hor_pos = new int[1];
    int[] kr_dir = new int[1];
    int kr_max_index;
    int r;
    int g;
    int b;
    Color temp_color;
    KnightRiderOptions options = null;

    public KnightRider(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public KnightRider(int[] _size, int _speed) {
        super("Knight Rider;5;20;2;255;0;0;", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new KnightRiderOptions(this);
        this.options.setVisible(true);
    }

    @Override
    void generateImage(Color[] image) {
        int y;
        if (this.parameter_changed) {
            this.kr_width = Integer.parseInt(this.parameter_array[1]);
            this.kr_length = Integer.parseInt(this.parameter_array[2]);
            this.kr_segment_size = Integer.parseInt(this.parameter_array[3]);
            this.kr_red = Integer.parseInt(this.parameter_array[4]);
            this.kr_green = Integer.parseInt(this.parameter_array[5]);
            this.kr_blue = Integer.parseInt(this.parameter_array[6]);
            this.kr_intensities = new int[this.size[0]];
            this.kr_dir[0] = 1;
            this.kr_hor_pos[0] = 0;
            this.kr_width = (int)Math.ceil((float)this.size[1] * (float)this.kr_width / 100.0f);
            this.kr_vert_pos = (int)Math.ceil((double)this.size[1] * 50.0 / 100.0) - this.kr_width / 2;
            if (this.size[1] % 2 == 1) {
                --this.kr_vert_pos;
            }
            this.kr_max_index = this.size[0] / this.kr_segment_size;
            int x = 0;
            while (x < this.size[0]) {
                y = 0;
                while (y < this.size[1]) {
                    image[y * this.size[0] + x] = Color.black;
                    ++y;
                }
                ++x;
            }
            this.parameter_changed = false;
            this.options = null;
        }
        if (this.kr_dir[0] == 1) {
            int[] kr_hor_pos = this.kr_hor_pos;
            boolean n = false;
            kr_hor_pos[0] = kr_hor_pos[0] + 1;
        } else {
            int[] kr_hor_pos2 = this.kr_hor_pos;
            boolean n2 = false;
            kr_hor_pos2[0] = kr_hor_pos2[0] - 1;
        }
        if (this.kr_hor_pos[0] == this.kr_max_index) {
            this.kr_dir[0] = 0;
        }
        if (this.kr_hor_pos[0] == 0) {
            this.kr_dir[0] = 1;
        }
        int a = 0;
        while (a < this.kr_max_index) {
            if (this.kr_intensities[a] > 0) {
                int n3;
                int[] kr_intensities = this.kr_intensities;
                int n = n3 = a;
                kr_intensities[n] = kr_intensities[n] - 1;
            }
            if (a == this.kr_hor_pos[0]) {
                this.kr_intensities[a] = this.kr_length;
            }
            this.r = (int)((float)this.kr_red * ((float)this.kr_intensities[a] / (float)this.kr_length));
            this.g = (int)((float)this.kr_green * ((float)this.kr_intensities[a] / (float)this.kr_length));
            this.b = (int)((float)this.kr_blue * ((float)this.kr_intensities[a] / (float)this.kr_length));
            this.temp_color = new Color(this.r, this.g, this.b);
            y = 0;
            while (y < this.kr_width) {
                int j = 0;
                while (j < this.kr_segment_size) {
                    image[(this.kr_vert_pos + y) * this.size[0] + (j + a * this.kr_segment_size)] = this.temp_color;
                    ++j;
                }
                ++y;
            }
            ++a;
        }
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }
}

