/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.FractalOptions;
import Generator.SuperGenerator;
import java.awt.Color;
import java.util.Random;

public class Fractal
extends SuperGenerator {
    int[][] color;
    int[][] level;
    int grow_size = 3;
    boolean distortion = true;
    int dist_strength = 30;
    Color temp_color = Color.BLACK;
    Random rand = new Random();
    FractalOptions options = null;

    public Fractal(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public Fractal(int[] _size, int _speed) {
        super("Fractal;true;30;", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new FractalOptions(this);
        this.options.setVisible(true);
    }

    @Override
    void generateImage(Color[] image) {
        int y;
        int x;
        if (this.parameter_changed) {
            this.distortion = Boolean.parseBoolean(this.parameter_array[1]);
            this.dist_strength = Integer.parseInt(this.parameter_array[2]);
            this.color = new int[this.size[0]][this.size[1]];
            this.level = new int[this.size[0]][this.size[1]];
            x = 0;
            while (x < this.size[0]) {
                y = 0;
                while (y < this.size[1]) {
                    this.color[x][y] = 0;
                    this.level[x][y] = 0;
                    ++y;
                }
                ++x;
            }
            x = 0;
            while (x < this.size[0]) {
                this.color[x][this.size[1] / 3 * 1] = 1;
                this.color[x][this.size[1] / 3 * 2] = 3;
                ++x;
            }
            int y2 = 0;
            while (y2 < this.size[1]) {
                this.color[this.size[0] / 3 * 1][y2] = 2;
                this.color[this.size[0] / 3 * 2][y2] = 3;
                ++y2;
            }
            this.parameter_changed = false;
            this.options = null;
        }
        x = 0;
        while (x < this.size[0]) {
            y = 0;
            while (y < this.size[1]) {
                int pos_x = 0;
                int pos_y = 0;
                while (pos_x == 0 && pos_y == 0) {
                    pos_x = this.rand.nextInt(3);
                    pos_y = this.rand.nextInt(3);
                }
                pos_y += y - 1;
                if ((pos_x += x - 1) < 0) {
                    pos_x = this.size[0] - 1;
                }
                if (pos_y < 0) {
                    pos_y = this.size[1] - 1;
                }
                if (pos_x > this.size[0] - 1) {
                    pos_x = 0;
                }
                if (pos_y > this.size[1] - 1) {
                    pos_y = 0;
                }
                if (this.color[x][y] == 0 && this.color[pos_x][pos_y] != 0 && this.level[pos_x][pos_y] < this.grow_size) {
                    this.color[x][y] = this.color[pos_x][pos_y];
                    this.level[x][y] = this.level[pos_x][pos_y] + 1;
                } else {
                    switch (this.color[x][y]) {
                        case 1: {
                            if (this.color[pos_x][pos_y] == 3) {
                                int[] nArray = this.level[x];
                                int n = y;
                                nArray[n] = nArray[n] - 1;
                                int[] nArray2 = this.level[pos_x];
                                int n2 = pos_y;
                                nArray2[n2] = nArray2[n2] + 1;
                            }
                            if (this.color[pos_x][pos_y] != 2) break;
                            int[] nArray = this.level[x];
                            int n = y;
                            nArray[n] = nArray[n] + 1;
                            int[] nArray3 = this.level[pos_x];
                            int n3 = pos_y;
                            nArray3[n3] = nArray3[n3] - 1;
                            break;
                        }
                        case 2: {
                            if (this.color[pos_x][pos_y] == 1) {
                                int[] nArray = this.level[x];
                                int n = y;
                                nArray[n] = nArray[n] - 1;
                                int[] nArray4 = this.level[pos_x];
                                int n4 = pos_y;
                                nArray4[n4] = nArray4[n4] + 1;
                            }
                            if (this.color[pos_x][pos_y] != 3) break;
                            int[] nArray = this.level[x];
                            int n = y;
                            nArray[n] = nArray[n] + 1;
                            int[] nArray5 = this.level[pos_x];
                            int n5 = pos_y;
                            nArray5[n5] = nArray5[n5] - 1;
                            break;
                        }
                        case 3: {
                            if (this.color[pos_x][pos_y] == 2) {
                                int[] nArray = this.level[x];
                                int n = y;
                                nArray[n] = nArray[n] - 1;
                                int[] nArray6 = this.level[pos_x];
                                int n6 = pos_y;
                                nArray6[n6] = nArray6[n6] + 1;
                            }
                            if (this.color[pos_x][pos_y] != 1) break;
                            int[] nArray = this.level[x];
                            int n = y;
                            nArray[n] = nArray[n] + 1;
                            int[] nArray7 = this.level[pos_x];
                            int n7 = pos_y;
                            nArray7[n7] = nArray7[n7] - 1;
                        }
                    }
                    if (this.level[x][y] < 0) {
                        this.level[x][y] = 0;
                    }
                    if (this.level[x][y] > this.grow_size) {
                        this.color[x][y] = this.color[pos_x][pos_y];
                        this.level[x][y] = 0;
                    }
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.size[0]) {
            y = 0;
            while (y < this.size[1]) {
                int r;
                if (this.distortion && (r = this.rand.nextInt(10000)) < this.dist_strength) {
                    this.color[x][y] = this.rand.nextInt(3) + 1;
                }
                switch (this.color[x][y]) {
                    case 0: {
                        this.temp_color = Color.BLACK;
                        break;
                    }
                    case 1: {
                        this.temp_color = Color.RED;
                        break;
                    }
                    case 2: {
                        this.temp_color = Color.GREEN;
                        break;
                    }
                    case 3: {
                        this.temp_color = Color.BLUE;
                    }
                }
                image[y * this.size[0] + x] = this.temp_color;
                ++y;
            }
            ++x;
        }
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }
}

