/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.SuperGenerator;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class CaptureOptions
extends JFrame {
    boolean set_size = false;
    boolean global_flag = false;
    String active_generator = "";
    SuperGenerator generator;
    private JButton pb_close;

    public CaptureOptions(SuperGenerator generator) {
        this.initComponents();
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Icons/Logo.png")).getImage());
        this.addMouseListener(new MouseAdapter(){});
        this.generator = generator;
    }

    private void initComponents() {
        this.pb_close = new JButton();
        this.setTitle("Capture region");
        this.setBounds(new Rectangle(100, 100, 0, 0));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                CaptureOptions.this.formComponentHidden(evt);
            }

            @Override
            public void componentMoved(ComponentEvent evt) {
                CaptureOptions.this.formComponentMoved(evt);
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                CaptureOptions.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                CaptureOptions.this.formComponentShown(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                CaptureOptions.this.formMouseDragged(evt);
            }
        });
        this.pb_close.setText("Hide");
        this.pb_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CaptureOptions.this.pb_closeActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(257, Short.MAX_VALUE).addComponent(this.pb_close).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(136, Short.MAX_VALUE).addComponent(this.pb_close).addContainerGap()));
        this.pack();
    }

    private void formComponentShown(ComponentEvent evt) {
        String[] parameter_array = this.generator.getParameterArray();
        int pos_x = Integer.parseInt(parameter_array[1]);
        int pos_y = Integer.parseInt(parameter_array[2]);
        int width = Integer.parseInt(parameter_array[3]);
        int height = Integer.parseInt(parameter_array[4]);
        this.setSize(width, height);
        this.setLocation(pos_x, pos_y);
        this.global_flag = true;
    }

    private void formMouseDragged(MouseEvent evt) {
    }

    private void pb_closeActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formComponentHidden(ComponentEvent evt) {
        this.global_flag = false;
    }

    private void formComponentMoved(ComponentEvent evt) {
        int w = this.getWidth();
        int h = this.getHeight();
        int x = this.getX();
        int y = this.getY();
        this.parameter_changed(x, y, w, h);
    }

    private void formComponentResized(ComponentEvent evt) {
        int w = this.getWidth();
        int h = this.getHeight();
        int x = this.getX();
        int y = this.getY();
        this.parameter_changed(x, y, w, h);
    }

    private void parameter_changed(int x, int y, int w, int h) {
        if (this.global_flag) {
            String paramter_string = "Capture;" + x + ";" + y + ";" + w + ";" + h;
            this.generator.setParameters(paramter_string);
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CaptureOptions.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex2) {
            Logger.getLogger(CaptureOptions.class.getName()).log(Level.SEVERE, null, ex2);
        }
        catch (IllegalAccessException ex3) {
            Logger.getLogger(CaptureOptions.class.getName()).log(Level.SEVERE, null, ex3);
        }
        catch (UnsupportedLookAndFeelException ex4) {
            Logger.getLogger(CaptureOptions.class.getName()).log(Level.SEVERE, null, ex4);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

