/*
 * Decompiled with CFR 0.152.
 */
package Filter;

import java.awt.Color;

public class Filter {
    private FilterMode filter_mode = FilterMode.NONE;

    public void setFilterMode(FilterMode filter_mode) {
        this.filter_mode = filter_mode;
    }

    public FilterMode getFilterMode() {
        return this.filter_mode;
    }

    public void doFiltering(Color[] image_in, Color[] image_out) {
        switch (this.filter_mode) {
            case NONE: {
                this.filterNone(image_in, image_out);
                break;
            }
            case INVERT: {
                this.filterInvert(image_in, image_out);
                break;
            }
            case MONOCHROME: {
                this.filterMonochrome(image_in, image_out);
                break;
            }
            case THRESHOLD_1: {
                this.filterTH1(image_in, image_out);
                break;
            }
            case THRESHOLD_2: {
                this.filterTH2(image_in, image_out);
            }
        }
    }

    private void filterNone(Color[] image_in, Color[] image_out) {
        int frame_size = image_in.length;
        System.arraycopy(image_in, 0, image_out, 0, frame_size);
    }

    private void filterInvert(Color[] image_in, Color[] image_out) {
        int frame_size = image_in.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = 255 - image_in[i].getRed();
            int g = 255 - image_in[i].getGreen();
            int b = 255 - image_in[i].getBlue();
            image_out[i] = color = new Color(r, g, b);
            ++i;
        }
    }

    private void filterMonochrome(Color[] image_in, Color[] image_out) {
        int frame_size = image_in.length;
        int i = 0;
        while (i < frame_size) {
            Color color;
            int r = image_in[i].getRed();
            int g = image_in[i].getGreen();
            int b = image_in[i].getBlue();
            int gr = (int)Math.floor((double)b * (double)0.11f + (double)g * (double)0.59f + (double)r * (double)0.3f);
            image_out[i] = color = new Color(gr, gr, gr);
            ++i;
        }
    }

    private void filterTH1(Color[] image_in, Color[] image_out) {
        int frame_size = image_in.length;
        int th = 200;
        int i = 0;
        while (i < frame_size) {
            Color temp_color;
            int r = image_in[i].getRed();
            int g = image_in[i].getGreen();
            int b = image_in[i].getBlue();
            if (r > 200) {
                r = 0;
            }
            if (g > 200) {
                g = 0;
            }
            if (b > 200) {
                b = 0;
            }
            image_out[i] = temp_color = new Color(r, g, b);
            ++i;
        }
    }

    private void filterTH2(Color[] image_in, Color[] image_out) {
        int frame_size = image_in.length;
        int th = 200;
        int i = 0;
        while (i < frame_size) {
            Color temp_color;
            int r = image_in[i].getRed();
            int g = image_in[i].getGreen();
            int b = image_in[i].getBlue();
            if (r < 200) {
                r = 0;
            }
            if (g < 200) {
                g = 0;
            }
            if (b < 200) {
                b = 0;
            }
            image_out[i] = temp_color = new Color(r, g, b);
            ++i;
        }
    }

    public static enum FilterMode {
        NONE("None"),
        INVERT("Invert"),
        MONOCHROME("Monochrome"),
        THRESHOLD_1("Threshold_1"),
        THRESHOLD_2("Threshold_2");

        private final String displayed_text;

        private FilterMode(String s) {
            this.displayed_text = s;
        }

        public String toString() {
            return this.displayed_text;
        }
    }
}

