/*
 * Decompiled with CFR 0.152.
 */
package Audio;

public class FFT {
    private float[] xre;
    private float[] xim;
    private float[] mag;
    private float[] fftSin;
    private float[] fftCos;
    private int[] fftBr;
    private int ss;
    private int ss2;
    private int nu;
    private int nu1;

    public FFT(int pSampleSize) {
        this.ss = pSampleSize;
        this.ss2 = this.ss >> 1;
        this.xre = new float[this.ss];
        this.xim = new float[this.ss];
        this.mag = new float[this.ss2];
        this.nu = (int)(Math.log(this.ss) / Math.log(2.0));
        this.nu1 = this.nu - 1;
        this.prepareFFTTables();
    }

    private int bitrev(int j, int nu) {
        int j2 = j;
        int k = 0;
        int i = 1;
        while (i <= nu) {
            int j3 = j2 >> 1;
            k = (k << 1) + j2 - (j3 << 1);
            j2 = j3;
            ++i;
        }
        return k;
    }

    public float[] calculate(float[] pSample) {
        int n2 = this.ss2;
        int nu1 = this.nu - 1;
        int wAps = pSample.length / this.ss;
        int a = 0;
        int b = 0;
        while (a < pSample.length) {
            this.xre[b] = pSample[a];
            this.xim[b] = 0.0f;
            a += wAps;
            ++b;
        }
        int x = 0;
        int l = 1;
        while (l <= this.nu) {
            int k = 0;
            while (k < this.ss) {
                int i = 1;
                while (i <= n2) {
                    int n4;
                    int n3;
                    float c = this.fftCos[x];
                    float s = this.fftSin[x];
                    int kn2 = k + n2;
                    float tr = this.xre[kn2] * c + this.xim[kn2] * s;
                    float ti = this.xim[kn2] * c - this.xre[kn2] * s;
                    this.xre[kn2] = this.xre[k] - tr;
                    this.xim[kn2] = this.xim[k] - ti;
                    float[] xre = this.xre;
                    int n = n3 = k;
                    xre[n] = xre[n] + tr;
                    float[] xim = this.xim;
                    int n5 = n4 = k++;
                    xim[n5] = xim[n5] + ti;
                    ++x;
                    ++i;
                }
                k += n2;
            }
            --nu1;
            n2 >>= 1;
            ++l;
        }
        int k = 0;
        while (k < this.ss) {
            int r = this.fftBr[k];
            if (r > k) {
                float tr = this.xre[k];
                float ti = this.xim[k];
                this.xre[k] = this.xre[r];
                this.xim[k] = this.xim[r];
                this.xre[r] = tr;
                this.xim[r] = ti;
            }
            ++k;
        }
        this.mag[0] = (float)Math.sqrt(this.xre[0] * this.xre[0] + this.xim[0] * this.xim[0]) / (float)this.ss;
        int i = 1;
        while (i < this.ss2) {
            this.mag[i] = 2.0f * (float)Math.sqrt(this.xre[i] * this.xre[i] + this.xim[i] * this.xim[i]) / (float)this.ss;
            ++i;
        }
        return this.mag;
    }

    /*
     * Unable to fully structure code
     */
    private void prepareFFTTables() {
        n2 = this.ss2;
        nu1 = this.nu - 1;
        this.fftSin = new float[this.nu * n2];
        this.fftCos = new float[this.nu * n2];
        k = 0;
        x = 0;
        l = 1;
        ** GOTO lbl26
        {
            i = 1;
            while (i <= n2) {
                p = this.bitrev(k >> nu1, this.nu);
                arg = 6.2831855f * p / (float)this.ss;
                this.fftSin[x] = (float)Math.sin(arg);
                this.fftCos[x] = (float)Math.cos(arg);
                ++k;
                ++x;
                ++i;
            }
            k += n2;
            do {
                if (k < this.ss) continue block0;
                k = 0;
                --nu1;
                n2 >>= 1;
                ++l;
lbl26:
                // 2 sources

            } while (l <= this.nu);
        }
        this.fftBr = new int[this.ss];
        k = 0;
        while (k < this.ss) {
            this.fftBr[k] = this.bitrev(k, this.nu);
            ++k;
        }
    }
}

