/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalTextFieldUI;

public class BaseTextFieldUI
extends MetalTextFieldUI {
    private Border orgBorder = null;
    private FocusListener focusListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BaseTextFieldUI();
    }

    protected void installListeners() {
        super.installListeners();
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            this.focusListener = new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    if (BaseTextFieldUI.this.getComponent() != null) {
                        BaseTextFieldUI.this.orgBorder = BaseTextFieldUI.this.getComponent().getBorder();
                        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                        if (lookAndFeel instanceof AbstractLookAndFeel && BaseTextFieldUI.this.orgBorder instanceof UIResource) {
                            Border border = ((AbstractLookAndFeel)lookAndFeel).getBorderFactory().getFocusFrameBorder();
                            BaseTextFieldUI.this.getComponent().setBorder(border);
                        }
                        BaseTextFieldUI.this.getComponent().invalidate();
                        BaseTextFieldUI.this.getComponent().repaint();
                    }
                }

                public void focusLost(FocusEvent focusEvent) {
                    if (BaseTextFieldUI.this.getComponent() != null && BaseTextFieldUI.this.orgBorder instanceof UIResource) {
                        BaseTextFieldUI.this.getComponent().setBorder(BaseTextFieldUI.this.orgBorder);
                        BaseTextFieldUI.this.getComponent().invalidate();
                        BaseTextFieldUI.this.getComponent().repaint();
                    }
                }
            };
            this.getComponent().addFocusListener(this.focusListener);
        }
    }

    protected void uninstallListeners() {
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        super.uninstallListeners();
    }

    protected void paintBackground(Graphics graphics) {
        graphics.setColor(this.getComponent().getBackground());
        if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && this.getComponent().hasFocus() && this.getComponent().isEditable()) {
            graphics.setColor(AbstractLookAndFeel.getTheme().getFocusBackgroundColor());
        }
        graphics.fillRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
    }

    protected void paintSafely(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object object = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paintSafely(graphics);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        }
    }
}

