/*
 * Decompiled with CFR 0.152.
 */
package Remote;

import Main.GlediatorModel;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class RemoteControl
extends JFrame {
    GlediatorModel glediator_model;
    private boolean connected;
    private DatagramSocket verbindung;
    private Timer udp_timer;
    ActionListener udp_timer_task = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            try {
                RemoteControl.this.receive_udp();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    };
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private static JLabel lbl_status;
    private static JButton pb_connect_to_GRC;
    private JButton pb_done;
    private static JTextField tf_GRC_IP;
    private static JTextField tf_GRC_Port;
    private JTextField tf_my_port;

    public RemoteControl(GlediatorModel glediator_model) {
        this.initComponents();
        this.setIconImage(new ImageIcon(this.getClass().getResource("/Icons/Logo.png")).getImage());
        this.glediator_model = glediator_model;
        this.connected = false;
        this.verbindung = null;
        this.udp_timer = new Timer(100, this.udp_timer_task);
        this.udp_timer.setRepeats(true);
        this.udp_timer.setDelay(100);
        this.udp_timer.start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        tf_GRC_IP = new JTextField();
        this.jLabel2 = new JLabel();
        tf_GRC_Port = new JTextField();
        lbl_status = new JLabel();
        pb_connect_to_GRC = new JButton();
        this.pb_done = new JButton();
        this.jLabel3 = new JLabel();
        this.tf_my_port = new JTextField();
        this.setTitle("G.R.C. - Setup");
        this.setBounds(new Rectangle(100, 100, 0, 0));
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setText("G.R.C. - IP                                                    ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        tf_GRC_IP.setText("localhost");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)tf_GRC_IP, gridBagConstraints);
        this.jLabel2.setText("G.R.C.- Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        tf_GRC_Port.setText("12500");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)tf_GRC_Port, gridBagConstraints);
        lbl_status.setText("---");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)lbl_status, gridBagConstraints);
        pb_connect_to_GRC.setText("Open Connection to G.R.C.");
        pb_connect_to_GRC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteControl.this.pb_connect_to_GRCActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)pb_connect_to_GRC, gridBagConstraints);
        this.pb_done.setText("Done");
        this.pb_done.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteControl.this.pb_doneActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.pb_done, gridBagConstraints);
        this.jLabel3.setText("My-Port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.tf_my_port.setText("15200");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.getContentPane().add((Component)this.tf_my_port, gridBagConstraints);
        this.pack();
    }

    private void pb_doneActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void pb_connect_to_GRCActionPerformed(ActionEvent evt) {
        if (!this.connected) {
            try {
                this.verbindung = new DatagramSocket(Integer.parseInt(this.tf_my_port.getText()));
                lbl_status.setText("Data socked opened succesfully.");
                pb_connect_to_GRC.setText("Disconnect Data Socket");
                this.connected = true;
                tf_GRC_IP.setEnabled(false);
                tf_GRC_Port.setEnabled(false);
                this.tf_my_port.setEnabled(false);
                this.send_scene_list();
            }
            catch (SocketException ex) {
                lbl_status.setText(ex.toString());
                this.connected = false;
                tf_GRC_IP.setEnabled(true);
                tf_GRC_Port.setEnabled(true);
                this.tf_my_port.setEnabled(true);
            }
        } else {
            try {
                this.verbindung.close();
                lbl_status.setText("Data socked closed.");
                pb_connect_to_GRC.setText("Open Connection to G.R.C.");
                this.connected = false;
                tf_GRC_IP.setEnabled(true);
                tf_GRC_Port.setEnabled(true);
                this.tf_my_port.setEnabled(true);
            }
            catch (Exception ex) {
                Logger.getLogger(RemoteControl.class.getName()).log(Level.SEVERE, null, ex);
                lbl_status.setText("Error closing data socket!");
                this.connected = true;
                tf_GRC_IP.setEnabled(false);
                tf_GRC_Port.setEnabled(false);
                this.tf_my_port.setEnabled(false);
            }
        }
    }

    public void send_scene_list() {
        if (this.connected) {
            try {
                this.send_udp("GLEDIATOR;CLEAR_LIST;DUMMY;");
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
        String[] scene_list = this.glediator_model.scene_list.getSceneListEntrieNames();
        int scene_count = this.glediator_model.scene_list.getNumberOfEntries();
        for (int j = 0; j < scene_count; ++j) {
            if (!this.connected) continue;
            try {
                this.send_udp("GLEDIATOR;ADD_SCENE;" + scene_list[j] + ";");
                continue;
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
        if (this.connected) {
            try {
                int index = this.glediator_model.scene_list.getSelectedIndex();
                this.send_udp("GLEDIATOR;SET_SELECTED_INDEX;" + index + ";");
            }
            catch (IOException ex) {
                Logger.getLogger(RemoteControl.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void receive_udp() throws IOException {
        byte[] buf = new byte[100];
        DatagramPacket packet = new DatagramPacket(buf, buf.length);
        if (this.connected) {
            this.verbindung.setSoTimeout(25);
            this.verbindung.receive(packet);
            if (packet.getLength() != 0) {
                int scene_index;
                String data = new String(packet.getData());
                String[] param = data.split(";");
                lbl_status.setText(param[0] + ";" + param[1] + ";" + param[2]);
                if (param[0].equals("GLEDIATOR") && param[1].equals("SET_SCENE")) {
                    scene_index = Integer.parseInt(param[2]);
                    this.glediator_model.left_scene.setScene(this.glediator_model.scene_list.getSceneParameter(scene_index));
                    this.glediator_model.triggerGuiUpdate();
                }
                if (param[0].equals("GLEDIATOR") && param[1].equals("SET_SCENE_LEFT")) {
                    scene_index = Integer.parseInt(param[2]);
                    this.glediator_model.left_scene.setScene(this.glediator_model.scene_list.getSceneParameter(scene_index));
                    this.glediator_model.triggerGuiUpdate();
                }
                if (param[0].equals("GLEDIATOR") && param[1].equals("SET_SCENE_RIGHT")) {
                    scene_index = Integer.parseInt(param[2]);
                    this.glediator_model.right_scene.setScene(this.glediator_model.scene_list.getSceneParameter(scene_index));
                    this.glediator_model.triggerGuiUpdate();
                }
                if (param[0].equals("GLEDIATOR") && param[1].equals("SET_FADER_LEVEL")) {
                    int fader_value = Integer.parseInt(param[2]);
                    this.glediator_model.fader.setFaderValue(fader_value);
                    this.glediator_model.triggerGuiUpdate();
                }
                if (param[0].equals("GLEDIATOR") && param[1].equals("SET_STROBE")) {
                    int strobe_active = Integer.parseInt(param[2]);
                    if (strobe_active == 1) {
                        this.glediator_model.activateStrobe();
                    } else {
                        this.glediator_model.deactivateStrobe();
                    }
                    this.glediator_model.triggerGuiUpdate();
                }
                if (param[0].equals("GLEDIATOR") && param[1].equals("GET_REQUEST")) {
                    this.send_scene_list();
                }
            }
        }
    }

    private void send_udp(String befehl) throws IOException {
        InetAddress address = InetAddress.getByName(tf_GRC_IP.getText());
        byte[] buf = befehl.getBytes();
        DatagramPacket packet = new DatagramPacket(buf, buf.length, address, Integer.parseInt(tf_GRC_Port.getText()));
        this.verbindung.send(packet);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(RemoteControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(RemoteControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(RemoteControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RemoteControl.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

