/*
 * Decompiled with CFR 0.152.
 */
package PlayList;

import Fader.Fader;
import SceneList.SceneParameter;
import java.awt.Color;

public class PlayListItem {
    public static final int DEFAULT_SCENE_TIME = 5000;
    public static final int DEFAULT_FADE_TIME = 200;
    public static final Fader.FaderMode DEFAULT_FADER_MODE = Fader.FaderMode.PROGRESSIVE;
    private SceneParameter scene_parameter = new SceneParameter();
    private int scene_time = 5000;
    private int fade_time = 200;
    private Fader.FaderMode fader_mode = DEFAULT_FADER_MODE;

    public void setSceneParameter(SceneParameter scene_parameter) {
        this.copySceneParameters(scene_parameter, this.scene_parameter);
    }

    public SceneParameter getSceneParameter() {
        SceneParameter result = new SceneParameter();
        this.copySceneParameters(this.scene_parameter, result);
        return result;
    }

    public void setSceneTime(int scene_time) {
        if (scene_time > 0) {
            this.scene_time = scene_time;
        } else {
            System.out.println("PlayList: Wrong scene time value.");
        }
    }

    public int getSceneTime() {
        return this.scene_time;
    }

    public void setFadeTime(int fade_time) {
        if (fade_time > 0) {
            this.fade_time = fade_time;
        } else {
            System.out.println("PlayList: Wrong fade time value.");
        }
    }

    public int getFadeTime() {
        return this.fade_time;
    }

    public void setFaderMode(Fader.FaderMode fader_mode) {
        this.fader_mode = fader_mode;
    }

    public Fader.FaderMode getFaderMode() {
        return this.fader_mode;
    }

    public String generateName() {
        String result = "<html>" + this.scene_parameter.scene_name + "<br>" + this.scene_time + "/" + this.fade_time * 100 + " ms" + "<br>" + this.fader_mode.toString() + "</html>";
        return result;
    }

    private void copySceneParameters(SceneParameter sour, SceneParameter dest) {
        dest.size[0] = sour.size[0];
        dest.size[1] = sour.size[1];
        for (int i = 0; i < 5; ++i) {
            dest.genertator_types[i] = sour.genertator_types[i];
            dest.generator_parameters[i] = sour.generator_parameters[i];
            dest.level_values[i] = sour.level_values[i];
            dest.speed_values[i] = sour.speed_values[i];
            dest.filter_modi[i] = sour.filter_modi[i];
            dest.mixer_modi[i] = sour.mixer_modi[i];
        }
        dest.effect_mode = sour.effect_mode;
        dest.effect_direction = sour.effect_direction;
        dest.effect_methode = sour.effect_methode;
        dest.effect_value = sour.effect_value;
        dest.effect_lower_limit = sour.effect_lower_limit;
        dest.effect_upper_limit = sour.effect_upper_limit;
        dest.effect_timer_value = sour.effect_timer_value;
        dest.effect_is_active = sour.effect_is_active;
        int size = dest.size[0] * dest.size[1];
        dest.preview_image = new Color[size];
        for (int i = 0; i < size; ++i) {
            dest.preview_image[i] = new Color(sour.preview_image[i].getRGB());
        }
        dest.scene_name = sour.scene_name;
    }
}

