/*
 * Decompiled with CFR 0.152.
 */
package Output;

import Output.BaudRate;
import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class SerialOutput {
    private CommPortIdentifier serialPortId;
    private Enumeration enumComm;
    private SerialPort serialPort;
    private OutputStream outputStream;
    private String[] com_port_list;
    private String[] com_port_dummy_list;
    private boolean port_open = false;

    SerialOutput() {
    }

    public String[] getComPorts() {
        try {
            this.enumComm = CommPortIdentifier.getPortIdentifiers();
            this.com_port_dummy_list = new String[100];
            int index = 0;
            while (this.enumComm.hasMoreElements()) {
                this.serialPortId = (CommPortIdentifier)this.enumComm.nextElement();
                if (this.serialPortId.getPortType() != 1) continue;
                this.com_port_dummy_list[index] = this.serialPortId.getName();
                ++index;
            }
            this.com_port_list = new String[index];
            System.arraycopy(this.com_port_dummy_list, 0, this.com_port_list, 0, index);
            System.out.println("Number of COM ports found: " + index);
        }
        catch (UnsatisfiedLinkError err) {
            System.out.println("It seems like you don't have any RXTX binary in your Glediator folder nor elsewhere!");
            this.com_port_list = new String[0];
        }
        return this.com_port_list;
    }

    public String startSerial(String com_port, BaudRate baud_rate) {
        String status = com_port + " started";
        boolean foundPort = false;
        if (this.port_open) {
            status = "Serial Port allready opend!";
        } else {
            this.enumComm = CommPortIdentifier.getPortIdentifiers();
            while (this.enumComm.hasMoreElements()) {
                this.serialPortId = (CommPortIdentifier)this.enumComm.nextElement();
                String portName = com_port;
                if (!portName.contentEquals(this.serialPortId.getName())) continue;
                foundPort = true;
                break;
            }
            if (!foundPort) {
                status = "Serial Port not found!";
            } else {
                try {
                    this.serialPort = (SerialPort)this.serialPortId.open("Open", 500);
                    this.port_open = true;
                }
                catch (PortInUseException e) {
                    status = "Serial Port occupied!";
                    this.port_open = false;
                }
                try {
                    this.outputStream = this.serialPort.getOutputStream();
                }
                catch (IOException e) {
                    status = "Access to output stream denied!";
                    this.port_open = false;
                }
                try {
                    int br_i = 0;
                    switch (baud_rate) {
                        case B_115200: {
                            br_i = 115200;
                            break;
                        }
                        case B_230400: {
                            br_i = 230400;
                            break;
                        }
                        case B_250000: {
                            br_i = 250000;
                            break;
                        }
                        case B_500000: {
                            br_i = 500000;
                            break;
                        }
                        case B_921600: {
                            br_i = 921600;
                            break;
                        }
                        case B_1000000: {
                            br_i = 1000000;
                            break;
                        }
                        case B_1250000: {
                            br_i = 1250000;
                        }
                    }
                    this.serialPort.setSerialPortParams(br_i, 8, 1, 0);
                }
                catch (Exception e) {
                    status = "Could not set interface parameters!";
                    this.port_open = false;
                }
            }
        }
        return status;
    }

    public String stopSerial(String _comport) {
        String status;
        if (this.port_open) {
            try {
                this.serialPort.close();
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
            this.port_open = false;
            status = _comport + " closed!";
        } else {
            status = _comport + " allready closed!";
        }
        return status;
    }

    public void sendSerialData(byte[] output_buffer, int size) {
        if (this.port_open) {
            try {
                this.outputStream.write(output_buffer, 0, size);
            }
            catch (IOException e) {
                System.out.println(e);
            }
        }
    }
}

