/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.PlasmaOptions;
import Generator.SuperGenerator;
import java.awt.Color;

public class Plasma
extends SuperGenerator {
    int plasma_step_width = 1;
    int plasma_cell_size_x = 3;
    int plasma_cell_size_y = 3;
    int[][] plasma_lut = new int[1537][3];
    float plasma_counter = 0.0f;
    PlasmaOptions options = null;

    public Plasma(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public Plasma(int[] _size, int _speed) {
        super("Plasma;10;4;4", _size, _speed);
    }

    void Generate_Plasma_LUT() {
        int i;
        for (i = 0; i < 256; ++i) {
            this.plasma_lut[i + 0][0] = 255;
            this.plasma_lut[i + 0][1] = i;
            this.plasma_lut[i + 0][2] = 0;
        }
        for (i = 0; i < 256; ++i) {
            this.plasma_lut[i + 256][0] = 255 - i;
            this.plasma_lut[i + 256][1] = 255;
            this.plasma_lut[i + 256][2] = 0;
        }
        for (i = 0; i < 256; ++i) {
            this.plasma_lut[i + 512][0] = 0;
            this.plasma_lut[i + 512][1] = 255;
            this.plasma_lut[i + 512][2] = i;
        }
        for (i = 0; i < 256; ++i) {
            this.plasma_lut[i + 768][0] = 0;
            this.plasma_lut[i + 768][1] = 255 - i;
            this.plasma_lut[i + 768][2] = 255;
        }
        for (i = 0; i < 256; ++i) {
            this.plasma_lut[i + 1024][0] = i;
            this.plasma_lut[i + 1024][1] = 0;
            this.plasma_lut[i + 1024][2] = 255;
        }
        for (i = 0; i < 256; ++i) {
            this.plasma_lut[i + 1280][0] = 255;
            this.plasma_lut[i + 1280][1] = 0;
            this.plasma_lut[i + 1280][2] = 255 - i;
        }
    }

    @Override
    public void Show_Config_Window() {
        this.options = new PlasmaOptions(this);
        this.options.setVisible(true);
    }

    @Override
    void generateImage(Color[] image) {
        if (this.parameter_changed) {
            this.plasma_step_width = Integer.parseInt(this.parameter_array[1]);
            this.plasma_cell_size_x = Integer.parseInt(this.parameter_array[2]);
            this.plasma_cell_size_y = Integer.parseInt(this.parameter_array[3]);
            this.Generate_Plasma_LUT();
            this.parameter_changed = false;
            this.options = null;
        }
        this.plasma_counter += (float)this.plasma_step_width / 10.0f;
        double calc1 = Math.sin(this.plasma_counter * 0.006f);
        double calc2 = Math.sin(this.plasma_counter * -0.06f);
        double xc = 25.0;
        for (int x = 0; x < this.size[0]; ++x) {
            double yc = 25.0;
            double s1 = 768.0 + 768.0 * Math.sin(xc += (double)((float)this.plasma_cell_size_x / 10.0f)) * calc1;
            for (int y = 0; y < this.size[1]; ++y) {
                double s2 = 768.0 + 768.0 * Math.sin(yc += (double)((float)this.plasma_cell_size_y / 10.0f)) * calc2;
                double s3 = 768.0 + 768.0 * Math.sin((xc + yc + (double)(this.plasma_counter / 10.0f)) / 2.0);
                int pixel = (int)((s1 + s2 + s3) / 3.0);
                int r = this.plasma_lut[pixel][0];
                int g = this.plasma_lut[pixel][1];
                int b = this.plasma_lut[pixel][2];
                image[y * this.size[0] + x] = new Color(r, g, b);
            }
        }
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }
}

