/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.GridOptions;
import Generator.SuperGenerator;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class Grid
extends SuperGenerator {
    int gr_pos_x = 0;
    int gr_pos_y = 0;
    int gr_step_x = 10;
    int gr_step_y = 14;
    int gr_size_x = 6;
    int gr_size_y = 12;
    int gr_angle = 45;
    int gr_rot_speed = 3;
    int gr_zoom = 100;
    int gr_min_zoom = 30;
    int gr_max_zoom = 100;
    int gr_zoom_step = 4;
    int gr_zoom_dir = 1;
    int gr_red = 255;
    int gr_green = 0;
    int gr_blue = 120;
    int gr_stroke = 1;
    boolean gr_rotate = true;
    boolean gr_pulse = true;
    boolean gr_random = true;
    String gr_shape = "Filled Circle";
    GridOptions options = null;

    public Grid(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public Grid(int[] _size, int _speed) {
        super("Grid;12;12;6;6;0;4;80;170;3;2;255;0;128;true;true;true;Open Oval", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new GridOptions(this);
        this.options.setVisible(true);
    }

    @Override
    void generateImage(Color[] image) {
        Random rnd = new Random();
        if (this.parameter_changed) {
            this.gr_step_x = Integer.parseInt(this.parameter_array[1]);
            this.gr_step_y = Integer.parseInt(this.parameter_array[2]);
            this.gr_size_x = Integer.parseInt(this.parameter_array[3]);
            this.gr_size_y = Integer.parseInt(this.parameter_array[4]);
            this.gr_angle = Integer.parseInt(this.parameter_array[5]);
            this.gr_rot_speed = Integer.parseInt(this.parameter_array[6]);
            this.gr_min_zoom = Integer.parseInt(this.parameter_array[7]);
            this.gr_max_zoom = Integer.parseInt(this.parameter_array[8]);
            this.gr_zoom_step = Integer.parseInt(this.parameter_array[9]);
            this.gr_stroke = Integer.parseInt(this.parameter_array[10]);
            this.gr_red = Integer.parseInt(this.parameter_array[11]);
            this.gr_green = Integer.parseInt(this.parameter_array[12]);
            this.gr_blue = Integer.parseInt(this.parameter_array[13]);
            this.gr_rotate = Boolean.parseBoolean(this.parameter_array[14]);
            this.gr_pulse = Boolean.parseBoolean(this.parameter_array[15]);
            this.gr_random = Boolean.parseBoolean(this.parameter_array[16]);
            this.gr_shape = this.parameter_array[17];
            this.parameter_changed = false;
            this.options = null;
        }
        BufferedImage tempImage = new BufferedImage(this.size[0], this.size[1], 2);
        Graphics2D gr = tempImage.createGraphics();
        if (this.gr_rotate) {
            this.gr_angle = this.speed_counter % 360;
        }
        gr.rotate((double)((float)this.gr_rot_speed * (float)this.gr_angle / 180.0f) * 3.1415, this.size[0] / 2, this.size[1] / 2);
        this.gr_pos_x = 0 - this.size[0];
        float zoom = (float)this.gr_zoom / 100.0f;
        gr.setStroke(new BasicStroke(this.gr_stroke));
        if (this.gr_random && rnd.nextInt(100) < 3) {
            this.gr_red = rnd.nextInt(256);
            this.gr_green = rnd.nextInt(256);
            this.gr_blue = rnd.nextInt(256);
        }
        gr.setColor(new Color(this.gr_red, this.gr_green, this.gr_blue));
        while (this.gr_pos_x <= 2 * this.size[0]) {
            this.gr_pos_y = 0 - this.size[1];
            while (this.gr_pos_y <= 2 * this.size[1]) {
                if (this.gr_shape.equals("Open Oval")) {
                    gr.drawOval(this.gr_pos_x - (int)((float)this.gr_size_x * zoom) / 2, this.gr_pos_y - (int)((float)this.gr_size_x * zoom) / 2, (int)((float)this.gr_size_x * zoom), (int)((float)this.gr_size_y * zoom));
                }
                if (this.gr_shape.equals("Filled Oval")) {
                    gr.fillOval(this.gr_pos_x - (int)((float)this.gr_size_x * zoom) / 2, this.gr_pos_y - (int)((float)this.gr_size_x * zoom) / 2, (int)((float)this.gr_size_x * zoom), (int)((float)this.gr_size_y * zoom));
                }
                if (this.gr_shape.equals("Open Rect")) {
                    gr.drawRect(this.gr_pos_x - (int)((float)this.gr_size_x * zoom) / 2, this.gr_pos_y - (int)((float)this.gr_size_x * zoom) / 2, (int)((float)this.gr_size_x * zoom), (int)((float)this.gr_size_y * zoom));
                }
                if (this.gr_shape.equals("Filled Rect")) {
                    gr.fillRect(this.gr_pos_x - (int)((float)this.gr_size_x * zoom) / 2, this.gr_pos_y - (int)((float)this.gr_size_x * zoom) / 2, (int)((float)this.gr_size_x * zoom), (int)((float)this.gr_size_y * zoom));
                }
                this.gr_pos_y += this.gr_step_y;
            }
            this.gr_pos_x += this.gr_step_x;
        }
        if (this.gr_pulse) {
            this.gr_zoom = this.gr_zoom_dir == 1 ? (this.gr_zoom += this.gr_zoom_step) : (this.gr_zoom -= this.gr_zoom_step);
            if (this.gr_zoom >= this.gr_max_zoom) {
                this.gr_zoom = this.gr_max_zoom;
                this.gr_zoom_dir = 0;
            }
            if (this.gr_zoom <= this.gr_min_zoom) {
                this.gr_zoom = this.gr_min_zoom;
                this.gr_zoom_dir = 1;
            }
        }
        gr.dispose();
        for (int x = 0; x < this.size[0]; ++x) {
            for (int y = 0; y < this.size[1]; ++y) {
                Color temp_color;
                image[y * this.size[0] + x] = temp_color = new Color(tempImage.getRGB(x, y));
            }
        }
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }
}

