/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.ExpandingObjectsOptions;
import Generator.SuperGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class ExpandingObjects
extends SuperGenerator {
    String eo_shape = "Open Circle";
    int eo_red = 255;
    int eo_green = 0;
    int eo_blue = 100;
    boolean eo_random = false;
    int eo_count = 5;
    int eo_size = 10;
    int eo_growth = 5;
    int[] eo_objects_pos_x = new int[this.eo_count];
    int[] eo_objects_pos_y = new int[this.eo_count];
    int[] eo_objects_expand = new int[this.eo_count];
    int[] eo_objects_fade = new int[this.eo_count];
    Color[] eo_objects_col = new Color[this.eo_count];
    ExpandingObjectsOptions options = null;

    public ExpandingObjects(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public ExpandingObjects(int[] _size, int _speed) {
        super("Expanding Objects;Open Circle;0;0;255;False;5;5;20", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new ExpandingObjectsOptions(this);
        this.options.setVisible(true);
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }

    @Override
    void generateImage(Color[] image) {
        Color temp_color;
        Random rnd = new Random();
        if (this.parameter_changed) {
            this.eo_shape = this.parameter_array[1];
            this.eo_red = Integer.parseInt(this.parameter_array[2]);
            this.eo_green = Integer.parseInt(this.parameter_array[3]);
            this.eo_blue = Integer.parseInt(this.parameter_array[4]);
            this.eo_random = Boolean.parseBoolean(this.parameter_array[5]);
            this.eo_count = Integer.parseInt(this.parameter_array[6]);
            this.eo_size = Integer.parseInt(this.parameter_array[7]);
            this.eo_growth = Integer.parseInt(this.parameter_array[8]);
            this.eo_objects_pos_x = new int[this.eo_count];
            this.eo_objects_pos_y = new int[this.eo_count];
            this.eo_objects_expand = new int[this.eo_count];
            this.eo_objects_fade = new int[this.eo_count];
            this.eo_objects_col = new Color[this.eo_count];
            for (int i = 0; i < this.eo_count; ++i) {
                this.eo_objects_pos_x[i] = rnd.nextInt(this.size[0]);
                this.eo_objects_pos_y[i] = rnd.nextInt(this.size[1]);
                this.eo_objects_expand[i] = rnd.nextInt(this.eo_growth);
                this.eo_objects_fade[i] = 0;
                this.eo_objects_col[i] = this.eo_random ? new Color(rnd.nextInt(256), rnd.nextInt(256), rnd.nextInt(256)) : new Color(this.eo_red, this.eo_green, this.eo_blue);
            }
            this.parameter_changed = false;
            this.options = null;
        }
        BufferedImage tempImage = new BufferedImage(this.size[0], this.size[1], 2);
        Graphics2D gr = tempImage.createGraphics();
        for (int i = 0; i < this.eo_count; ++i) {
            int r = (int)((float)this.eo_objects_col[i].getRed() * (1.0f - (float)this.eo_objects_fade[i] / (float)this.eo_growth));
            int g = (int)((float)this.eo_objects_col[i].getGreen() * (1.0f - (float)this.eo_objects_fade[i] / (float)this.eo_growth));
            int b = (int)((float)this.eo_objects_col[i].getBlue() * (1.0f - (float)this.eo_objects_fade[i] / (float)this.eo_growth));
            temp_color = new Color(r, g, b);
            int diameter = this.eo_size + this.eo_objects_expand[i];
            if (this.eo_objects_expand[i] < this.eo_growth) {
                gr.setColor(temp_color);
                int offset = diameter / 2;
                if (this.eo_shape.equals("Open Circle")) {
                    gr.drawOval(this.eo_objects_pos_x[i] - offset, this.eo_objects_pos_y[i] - offset, diameter, diameter);
                }
                if (this.eo_shape.equals("Filled Circle")) {
                    gr.fillOval(this.eo_objects_pos_x[i] - offset, this.eo_objects_pos_y[i] - offset, diameter, diameter);
                }
                if (this.eo_shape.equals("Open Rect")) {
                    gr.drawRect(this.eo_objects_pos_x[i] - offset, this.eo_objects_pos_y[i] - offset, diameter, diameter);
                }
                if (this.eo_shape.equals("Filled Rect")) {
                    gr.fillRect(this.eo_objects_pos_x[i] - offset, this.eo_objects_pos_y[i] - offset, diameter, diameter);
                }
                if (this.eo_shape.equals("Smiley")) {
                    gr.drawOval(this.eo_objects_pos_x[i] - offset, this.eo_objects_pos_y[i] - offset, diameter, diameter);
                    gr.drawOval(this.eo_objects_pos_x[i] - offset + diameter / 4 - diameter / 8, this.eo_objects_pos_y[i] - offset + diameter / 3, diameter / 4, diameter / 4);
                    gr.drawOval(this.eo_objects_pos_x[i] - offset + (int)((float)diameter * 0.75f) - diameter / 8, this.eo_objects_pos_y[i] - offset + diameter / 3, diameter / 4, diameter / 4);
                    gr.drawOval(this.eo_objects_pos_x[i] - offset + diameter / 4, this.eo_objects_pos_y[i] - offset + diameter / 3, diameter / 8, diameter / 8);
                    gr.drawOval(this.eo_objects_pos_x[i] - offset + (int)((float)diameter * 0.75f), this.eo_objects_pos_y[i] - offset + diameter / 3, diameter / 8, diameter / 8);
                    gr.drawArc(this.eo_objects_pos_x[i] - offset + diameter / 8, this.eo_objects_pos_y[i] - offset + diameter / 8, (int)((float)diameter * 0.8f), (int)((float)diameter * 0.8f), -20, -140);
                }
            }
            this.eo_objects_expand[i] = this.eo_objects_expand[i] + 2;
            this.eo_objects_fade[i] = this.eo_objects_fade[i] + 2;
            if (this.eo_objects_fade[i] >= this.eo_growth) {
                this.eo_objects_fade[i] = this.eo_growth;
            }
            if (this.eo_objects_expand[i] < this.eo_growth || rnd.nextInt(100) >= 10) continue;
            this.eo_objects_pos_x[i] = rnd.nextInt(this.size[0]);
            this.eo_objects_pos_y[i] = rnd.nextInt(this.size[1]);
            this.eo_objects_expand[i] = 0;
            this.eo_objects_fade[i] = 0;
        }
        gr.dispose();
        for (int x = 0; x < this.size[0]; ++x) {
            for (int y = 0; y < this.size[1]; ++y) {
                image[y * this.size[0] + x] = temp_color = new Color(tempImage.getRGB(x, y));
            }
        }
    }
}

