/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class CaptureThumbnail {
    public BufferedImage createThumbnail(BufferedImage inImage, int largestDimension) {
        try {
            int originalImageLargestDim;
            int sizeDifference;
            double scale;
            if (inImage.getWidth(null) > inImage.getHeight(null)) {
                scale = (double)largestDimension / (double)inImage.getWidth(null);
                sizeDifference = inImage.getWidth(null) - largestDimension;
                originalImageLargestDim = inImage.getWidth(null);
            } else {
                scale = (double)largestDimension / (double)inImage.getHeight(null);
                sizeDifference = inImage.getHeight(null) - largestDimension;
                originalImageLargestDim = inImage.getHeight(null);
            }
            BufferedImage outImage = new BufferedImage(100, 100, 1);
            if (scale < 1.0) {
                int numSteps = sizeDifference / 100;
                int stepSize = sizeDifference / numSteps;
                int stepWeight = stepSize / 2;
                int heavierStepSize = stepSize + stepWeight;
                int lighterStepSize = stepSize - stepWeight;
                double scaledW = inImage.getWidth(null);
                double scaledH = inImage.getHeight(null);
                int centerStep = numSteps % 2 == 1 ? (int)Math.ceil((double)numSteps / 2.0) : -1;
                Integer intermediateSize = originalImageLargestDim;
                Integer previousIntermediateSize = originalImageLargestDim;
                Integer i = 0;
                while (i < numSteps) {
                    int currentStepSize = i + 1 != centerStep ? (i == numSteps - 1 ? previousIntermediateSize - largestDimension : (numSteps - i > numSteps / 2 ? heavierStepSize : lighterStepSize)) : stepSize;
                    intermediateSize = previousIntermediateSize - currentStepSize;
                    scale = (double)intermediateSize.intValue() / (double)previousIntermediateSize.intValue();
                    scaledW = (double)((int)scaledW) * scale;
                    scaledH = (double)((int)scaledH) * scale;
                    outImage = new BufferedImage((int)scaledW, (int)scaledH, 1);
                    Graphics2D g2d = outImage.createGraphics();
                    g2d.setBackground(Color.WHITE);
                    g2d.clearRect(0, 0, outImage.getWidth(), outImage.getHeight());
                    g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    AffineTransform tx = new AffineTransform();
                    tx.scale(scale, scale);
                    g2d.drawImage(inImage, tx, null);
                    g2d.dispose();
                    inImage = (BufferedImage)new ImageIcon(outImage).getImage();
                    previousIntermediateSize = intermediateSize;
                    Integer n = i;
                    Integer n2 = i = Integer.valueOf(i + 1);
                }
            } else {
                outImage = new BufferedImage(inImage.getWidth(null), inImage.getHeight(null), 1);
                Graphics2D g2d = outImage.createGraphics();
                g2d.setBackground(Color.WHITE);
                g2d.clearRect(0, 0, outImage.getWidth(), outImage.getHeight());
                AffineTransform tx = new AffineTransform();
                tx.setToIdentity();
                g2d.drawImage(inImage, tx, null);
                g2d.dispose();
            }
            return outImage;
        }
        catch (Exception ex) {
            String errorMsg = "";
            errorMsg = errorMsg + "<br>Exception: " + ex.toString();
            errorMsg = errorMsg + "<br>Cause = " + ex.getCause();
            errorMsg = errorMsg + "<br>Stack Trace = ";
            StackTraceElement[] stackTrace = ex.getStackTrace();
            for (int traceLine = 0; traceLine < stackTrace.length; ++traceLine) {
                errorMsg = errorMsg + "<br>" + stackTrace[traceLine];
            }
            return null;
        }
    }
}

