/*
 * Decompiled with CFR 0.152.
 */
package Generator;

import Generator.CaptureOptions;
import Generator.CaptureThumbnail;
import Generator.SuperGenerator;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;

public class Capture
extends SuperGenerator {
    int cap_x = 100;
    int cap_y = 100;
    int cap_w = 300;
    int cap_h = 150;
    CaptureThumbnail cap_thumb = new CaptureThumbnail();
    CaptureOptions options = null;

    public Capture(String _parameter_string, int[] _size, int _speed) {
        super(_parameter_string, _size, _speed);
    }

    public Capture(int[] _size, int _speed) {
        super("Capture;100;100;600;300", _size, _speed);
    }

    @Override
    public void Show_Config_Window() {
        this.options = new CaptureOptions(this);
        this.options.setVisible(true);
    }

    @Override
    public void closeConfigWindow() {
        if (this.options != null) {
            this.options.setVisible(false);
            this.options = null;
        }
    }

    @Override
    void generateImage(Color[] image) {
        if (this.parameter_changed) {
            this.cap_x = Integer.parseInt(this.parameter_array[1]);
            this.cap_y = Integer.parseInt(this.parameter_array[2]);
            this.cap_w = Integer.parseInt(this.parameter_array[3]);
            this.cap_h = Integer.parseInt(this.parameter_array[4]);
            this.parameter_changed = false;
            this.options = null;
        }
        try {
            Robot robot = new Robot();
            Rectangle captureSize = new Rectangle(this.cap_x, this.cap_y, this.cap_w, this.cap_h);
            BufferedImage capt_image = robot.createScreenCapture(captureSize);
            BufferedImage resizedImage = this.cap_thumb.createThumbnail(capt_image, this.size[0]);
            if (resizedImage != null) {
                int hh = resizedImage.getHeight();
                int ww = resizedImage.getWidth();
                for (int xx = 0; xx < this.size[0]; ++xx) {
                    for (int yy = 0; yy < this.size[1]; ++yy) {
                        Color temp_color = Color.BLACK;
                        if (yy < hh & xx < ww) {
                            temp_color = new Color(resizedImage.getRGB(xx, yy));
                        }
                        image[yy * this.size[0] + xx] = temp_color;
                    }
                }
            }
        }
        catch (AWTException e) {
            System.out.println("Generator_Capture: Error while caturing.");
        }
    }
}

