/*
 * Decompiled with CFR 0.152.
 */
package Fader;

import Dimmer.Dimmer;
import java.awt.Color;

public class Fader {
    public static final FaderMode DEFAULT_FADER_MODE = FaderMode.LINEAR;
    public static final int DEFAULT_FADER_VALUE = 50;
    public static final int DEFAULT_FADE_TIME = 5;
    public static final int MIN_FADE_TIME = 1;
    public static final int MAX_FADE_TIME = 100;
    public static final int DEFAULT_INTENSITY = 100;
    private FaderMode fader_mode;
    private int fader_value = 50;
    private int fade_time = 5;
    private int[] matrix_size = new int[2];
    private Dimmer left_dimmer;
    private Dimmer right_dimmer;
    private Dimmer master_dimmer;

    public Fader() {
        this.fader_mode = DEFAULT_FADER_MODE;
        this.left_dimmer = new Dimmer();
        this.left_dimmer.setDimmerLevel(100);
        this.right_dimmer = new Dimmer();
        this.right_dimmer.setDimmerLevel(100);
        this.master_dimmer = new Dimmer();
        this.master_dimmer.setDimmerLevel(100);
    }

    public void setMatrixSize(int[] matrix_size) {
        if (matrix_size[0] > 0 && matrix_size[1] > 0) {
            this.matrix_size[0] = matrix_size[0];
            this.matrix_size[1] = matrix_size[1];
        } else {
            System.out.println("Fader: Wrong matrix size.");
        }
    }

    public void setFaderMode(FaderMode fader_mode) {
        this.fader_mode = fader_mode;
    }

    public FaderMode getFaderMode() {
        return this.fader_mode;
    }

    public void setFaderValue(int fader_value) {
        if (fader_value >= 0 && fader_value <= 100) {
            this.fader_value = fader_value;
        } else {
            System.out.println("Fader: Wrong fader value.");
        }
    }

    public int getFaderValue() {
        return this.fader_value;
    }

    public void setFadeTime(int fade_time) {
        if (fade_time >= 1 && fade_time <= 100) {
            this.fade_time = fade_time;
        } else {
            System.out.println("Fader: Wrong fade time value.");
        }
    }

    public int getFaderTime() {
        return this.fade_time;
    }

    public void setLeftIntensity(int left_intensity) {
        if (left_intensity >= 0 && left_intensity <= 100) {
            this.left_dimmer.setDimmerLevel(left_intensity);
        } else {
            System.out.println("Fader: Wrong value for left intensity.");
        }
    }

    public int getLeftIntensity() {
        return this.left_dimmer.getDimmerLevel();
    }

    public void setRightIntensity(int right_intensity) {
        if (right_intensity >= 0 && right_intensity <= 100) {
            this.right_dimmer.setDimmerLevel(right_intensity);
        } else {
            System.out.println("Fader: Wrong value for right intensity.");
        }
    }

    public int getRightIntensity() {
        return this.right_dimmer.getDimmerLevel();
    }

    public void setMasterIntensity(int master_intensity) {
        if (master_intensity >= 0 && master_intensity <= 100) {
            this.master_dimmer.setDimmerLevel(master_intensity);
        } else {
            System.out.println("Fader: Wrong value for master intensity.");
        }
    }

    public int getMasterIntensity() {
        return this.master_dimmer.getDimmerLevel();
    }

    public void doFading(Color[] left_image, Color[] right_image, Color[] main_image) {
        this.left_dimmer.doDimming(left_image);
        this.right_dimmer.doDimming(right_image);
        switch (this.fader_mode) {
            case LINEAR: {
                this.fadeLinear(left_image, right_image, main_image);
                break;
            }
            case PROGRESSIVE: {
                this.fadeProgressive(left_image, right_image, main_image);
                break;
            }
            case STRIPES_HOR: {
                this.fadeStripesHor(left_image, right_image, main_image);
                break;
            }
            case STRIPES_VERT: {
                this.fadeStripesVert(left_image, right_image, main_image);
                break;
            }
            case SHIFT_HOR: {
                this.fadeShiftHor(left_image, right_image, main_image);
                break;
            }
            case SHIFT_VERT: {
                this.fadeShiftVert(left_image, right_image, main_image);
                break;
            }
        }
        this.master_dimmer.doDimming(main_image);
    }

    private void fadeLinear(Color[] left_image, Color[] right_image, Color[] main_image) {
        float left = 1.0f - (float)this.fader_value / 100.0f;
        float right = (float)this.fader_value / 100.0f;
        int frame_size = main_image.length;
        for (int i = 0; i < frame_size; ++i) {
            int r = (int)(left * (float)left_image[i].getRed() + right * (float)right_image[i].getRed());
            int g = (int)(left * (float)left_image[i].getGreen() + right * (float)right_image[i].getGreen());
            int b = (int)(left * (float)left_image[i].getBlue() + right * (float)right_image[i].getBlue());
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            main_image[i] = new Color(r, g, b);
        }
    }

    private void fadeProgressive(Color[] left_image, Color[] right_image, Color[] main_image) {
        float right;
        float left;
        int frame_size = main_image.length;
        if (this.fader_value < 50) {
            left = 1.0f;
            right = (float)this.fader_value / 100.0f * 2.0f;
        } else {
            left = (1.0f - (float)this.fader_value / 100.0f) * 2.0f;
            right = 1.0f;
        }
        for (int i = 0; i < frame_size; ++i) {
            int r = (int)(left * (float)left_image[i].getRed() + right * (float)right_image[i].getRed());
            int g = (int)(left * (float)left_image[i].getGreen() + right * (float)right_image[i].getGreen());
            int b = (int)(left * (float)left_image[i].getBlue() + right * (float)right_image[i].getBlue());
            if (r > 255) {
                r = 255;
            }
            if (g > 255) {
                g = 255;
            }
            if (b > 255) {
                b = 255;
            }
            main_image[i] = new Color(r, g, b);
        }
    }

    private void fadeStripesHor(Color[] left_image, Color[] right_image, Color[] main_image) {
        int x;
        int y;
        int shift = (int)((float)this.matrix_size[0] * (float)this.fader_value / 100.0f);
        for (y = 0; y < this.matrix_size[1]; y += 2) {
            for (x = 0; x < this.matrix_size[0]; ++x) {
                main_image[y * this.matrix_size[0] + x] = x < shift ? new Color(right_image[y * this.matrix_size[0] + x].getRGB()) : new Color(left_image[y * this.matrix_size[0] + x].getRGB());
            }
        }
        shift = this.matrix_size[0] - shift;
        for (y = 1; y < this.matrix_size[1]; y += 2) {
            for (x = 0; x < this.matrix_size[0]; ++x) {
                main_image[y * this.matrix_size[0] + x] = x >= shift ? new Color(right_image[y * this.matrix_size[0] + x].getRGB()) : new Color(left_image[y * this.matrix_size[0] + x].getRGB());
            }
        }
    }

    private void fadeStripesVert(Color[] left_image, Color[] right_image, Color[] main_image) {
        int y;
        int x;
        int shift = (int)((float)this.matrix_size[1] * (float)this.fader_value / 100.0f);
        for (x = 0; x < this.matrix_size[0]; x += 2) {
            for (y = 0; y < this.matrix_size[1]; ++y) {
                main_image[y * this.matrix_size[0] + x] = y < shift ? new Color(right_image[y * this.matrix_size[0] + x].getRGB()) : new Color(left_image[y * this.matrix_size[0] + x].getRGB());
            }
        }
        shift = this.matrix_size[1] - shift;
        for (x = 1; x < this.matrix_size[0]; x += 2) {
            for (y = 0; y < this.matrix_size[1]; ++y) {
                main_image[y * this.matrix_size[0] + x] = y >= shift ? new Color(right_image[y * this.matrix_size[0] + x].getRGB()) : new Color(left_image[y * this.matrix_size[0] + x].getRGB());
            }
        }
    }

    private void fadeShiftHor(Color[] left_image, Color[] right_image, Color[] main_image) {
        int shift = (int)((float)this.matrix_size[0] * (float)this.fader_value / 100.0f);
        for (int y = 0; y < this.matrix_size[1]; ++y) {
            for (int x = 0; x < this.matrix_size[0]; ++x) {
                main_image[y * this.matrix_size[0] + x] = x < shift ? new Color(right_image[y * this.matrix_size[0] + x].getRGB()) : new Color(left_image[y * this.matrix_size[0] + x].getRGB());
            }
        }
    }

    private void fadeShiftVert(Color[] left_image, Color[] right_image, Color[] main_image) {
        int shift = (int)((float)this.matrix_size[1] * (float)this.fader_value / 100.0f);
        for (int y = 0; y < this.matrix_size[1]; ++y) {
            for (int x = 0; x < this.matrix_size[0]; ++x) {
                main_image[y * this.matrix_size[0] + x] = y < shift ? new Color(right_image[y * this.matrix_size[0] + x].getRGB()) : new Color(left_image[y * this.matrix_size[0] + x].getRGB());
            }
        }
    }

    public static enum FaderMode {
        LINEAR("Linear"),
        PROGRESSIVE("Progressive"),
        STRIPES_HOR("Stripes_Hor"),
        STRIPES_VERT("Stripes_Vert"),
        SHIFT_HOR("Shift_Hor"),
        SHIFT_VERT("Shift_Vert");

        private final String displayed_text;

        private FaderMode(String s) {
            this.displayed_text = s;
        }

        public String toString() {
            return this.displayed_text;
        }
    }
}

