/*
 * Decompiled with CFR 0.152.
 */
package Draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class DrawPanel
extends JPanel {
    Color[] image;
    int[] frame_size;
    int space;
    boolean block = true;

    public void setImage(Color[] image) {
        this.image = image;
    }

    public void setFrameSize(int[] frame_size) {
        this.frame_size = frame_size;
    }

    public void setSpace(int space) {
        this.space = space;
    }

    public void free() {
        this.block = false;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.block) {
            Graphics2D g2d = (Graphics2D)g;
            int[] diameter = new int[2];
            int width = this.getWidth();
            int eff_width = width - (this.frame_size[0] + 1) * this.space;
            diameter[0] = eff_width / this.frame_size[0];
            int height = this.getHeight();
            int eff_height = height - (this.frame_size[1] + 1) * this.space;
            diameter[1] = eff_height / this.frame_size[1];
            int offset_x = (width - (this.frame_size[0] + 1) * this.space - this.frame_size[0] * diameter[0]) / 2;
            int offset_y = (height - (this.frame_size[1] + 1) * this.space - this.frame_size[1] * diameter[1]) / 2;
            for (int x = 0; x < this.frame_size[0]; ++x) {
                for (int y = 0; y < this.frame_size[1]; ++y) {
                    g2d.setColor(this.image[y * this.frame_size[0] + x]);
                    double px_start = x * (diameter[0] + this.space) + this.space;
                    double py_start = y * (diameter[1] + this.space) + this.space;
                    double px_end = px_start + (double)diameter[0];
                    double py_end = py_start + (double)diameter[1];
                    int px_start_i = (int)Math.round(px_start);
                    int py_start_i = (int)Math.round(py_start);
                    int px_end_i = (int)Math.round(px_end);
                    int py_end_i = (int)Math.round(py_end);
                    int px = px_start_i;
                    int py = py_start_i;
                    int dx = px_end_i - px_start_i;
                    int dy = py_end_i - py_start_i;
                    g2d.fillRect(px + offset_x, py + offset_y, dx, dy);
                }
            }
        }
    }
}

