/*
 * Decompiled with CFR 0.152.
 */
package Audio;

import Audio.FFT;

public class SoundSpectrum {
    private float[] left;
    private float[] right;
    private int sampleSize = 512;
    private byte[] audioDataBuffer = null;
    private FFT fft = new FFT(512);
    private float[] old_FFT = new float[512];
    private int desiredBands = 12;

    public float[] do_fft(byte[] buffer, int number_of_binns, int[] sound_level) {
        this.audioDataBuffer = buffer;
        this.desiredBands = number_of_binns;
        this.handleAudioBytes();
        sound_level[0] = this.calculateRMSLevel(this.left);
        sound_level[1] = this.calculateRMSLevel(this.right);
        return this.computeFFT(this.mergeStereo(this.left, this.right));
    }

    private void handleAudioBytes() {
        this.left = new float[this.sampleSize];
        this.right = new float[this.sampleSize];
        int c = 0;
        int a = 0;
        while (a < this.sampleSize) {
            this.left[a] = (float)((this.audioDataBuffer[c + 1] << 8) + this.audioDataBuffer[c]) / 32767.0f;
            this.right[a] = (float)((this.audioDataBuffer[c + 3] << 8) + this.audioDataBuffer[c + 2]) / 32767.0f;
            ++a;
            c += 4;
        }
    }

    private float[] mergeStereo(float[] pLeft, float[] pRight) {
        for (int a = 0; a < pLeft.length; ++a) {
            pLeft[a] = (pLeft[a] + pRight[a]) / 2.0f;
        }
        return pLeft;
    }

    private float[] computeFFT(float[] pSample) {
        int saMultiplier = 256 / this.desiredBands;
        float c = 0.0f;
        float[] wFFT = this.fft.calculate(pSample);
        float wSadfrr = 0.03f;
        float[] spectrum = new float[this.desiredBands];
        int a = 0;
        for (int bd = 0; bd < this.desiredBands; ++bd) {
            float wFs = 0.0f;
            for (int b = 0; b < saMultiplier; ++b) {
                wFs += wFFT[a + b];
            }
            if ((wFs *= (float)Math.log(bd + 2)) > 1.0f) {
                wFs = 1.0f;
            }
            if (wFs >= this.old_FFT[a]) {
                this.old_FFT[a] = wFs;
            } else {
                int n = a;
                this.old_FFT[n] = this.old_FFT[n] - wSadfrr;
                if (this.old_FFT[a] < 0.0f) {
                    this.old_FFT[a] = 0.0f;
                }
                wFs = this.old_FFT[a];
            }
            spectrum[bd] = wFs;
            a += saMultiplier;
        }
        return spectrum;
    }

    private int calculateRMSLevel(float[] audioData) {
        float lSum = 0.0f;
        for (int i = 0; i < audioData.length; ++i) {
            lSum += audioData[i];
        }
        double dAvg = lSum / (float)audioData.length;
        double sumMeanSquare = 0.0;
        for (int j = 0; j < audioData.length; ++j) {
            sumMeanSquare += Math.pow((double)audioData[j] - dAvg, 2.0);
        }
        double averageMeanSquare = sumMeanSquare / (double)audioData.length;
        return (int)(200.0 * (Math.pow(averageMeanSquare, 0.5) + 0.0));
    }
}

